/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCIDFontStyle;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFFontDescriptor;
import com.adobe.internal.pdf.PDFFontFile;
import com.adobe.internal.pdf.PDFFontStretch;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFRectangle;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ASString;
import com.adobe.internal.pdf.cos.util.ByteStream;
import java.util.ArrayList;

class PDFCosFontDescriptor
extends PDFCosObject
implements PDFInstantiate {
    PDFCosFontDescriptor(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFCosFontDescriptor", cosObject);
    }

    ASName getFontName() {
        return this.getCosDictionary().getName(ASName.k_FontName);
    }

    ASString getFontFamily() {
        if (this.getCosDictionary().containsKey(ASName.k_FontFamily)) {
            return this.getCosDictionary().getString(ASName.k_FontFamily);
        }
        return null;
    }

    PDFFontStretch getFontStretch() {
        if (this.getCosDictionary().containsKey(ASName.k_FontStretch)) {
            ASName aSName = this.getCosDictionary().getName(ASName.k_FontStretch);
            return PDFFontStretch.getFontStretchForValue(aSName);
        }
        return null;
    }

    int getFontWeight() {
        int n = 400;
        if (this.getCosDictionary().containsKey(ASName.k_FontWeight)) {
            return this.getCosDictionary().getInt(ASName.k_FontWeight);
        }
        return n;
    }

    int getFlags() {
        return this.getCosDictionary().getInt(ASName.k_Flags);
    }

    boolean containsFontBBox() {
        return this.getCosDictionary().containsKey(ASName.k_FontBBox);
    }

    PDFRectangle getFontBBox() {
        if (this.containsFontBBox()) {
            CosObject cosObject = this.getCosDictionary().get(ASName.k_FontBBox);
            return (PDFRectangle)PDFRectangle.instantiate(cosObject);
        }
        return null;
    }

    double getItalicAngle() {
        return this.getCosDictionary().getDouble(ASName.k_ItalicAngle);
    }

    boolean containsAscent() {
        return this.getCosDictionary().containsKey(ASName.k_Ascent);
    }

    double getAscent() {
        if (this.containsAscent()) {
            return this.getCosDictionary().getDouble(ASName.k_Ascent);
        }
        return 0.0;
    }

    boolean containsDescent() {
        return this.getCosDictionary().containsKey(ASName.k_Descent);
    }

    double getDescent() {
        if (this.containsDescent()) {
            return this.getCosDictionary().getDouble(ASName.k_Descent);
        }
        return 0.0;
    }

    double getLeading() {
        if (this.getCosDictionary().containsKey(ASName.k_Leading)) {
            return this.getCosDictionary().getDouble(ASName.k_Leading);
        }
        return 0.0;
    }

    boolean containsCapHeight() {
        return this.getCosDictionary().containsKey(ASName.k_CapHeight);
    }

    double getCapHeight() {
        if (this.containsCapHeight()) {
            return this.getCosDictionary().getDouble(ASName.k_CapHeight);
        }
        return 0.0;
    }

    double getXHeight() {
        if (this.getCosDictionary().containsKey(ASName.k_XHeight)) {
            return this.getCosDictionary().getDouble(ASName.k_XHeight);
        }
        return 0.0;
    }

    boolean containsStemV() {
        return this.getCosDictionary().containsKey(ASName.k_StemV);
    }

    double getStemV() {
        if (this.containsStemV()) {
            return this.getCosDictionary().getDouble(ASName.k_StemV);
        }
        return 0.0;
    }

    double getStemH() {
        if (this.getCosDictionary().containsKey(ASName.k_StemH)) {
            return this.getCosDictionary().getDouble(ASName.k_StemH);
        }
        return 0.0;
    }

    double getAvgWidth() {
        if (this.getCosDictionary().containsKey(ASName.k_AvgWidth)) {
            return this.getCosDictionary().getDouble(ASName.k_AvgWidth);
        }
        return 0.0;
    }

    double getMaxWidth() {
        if (this.getCosDictionary().containsKey(ASName.k_MaxWidth)) {
            return this.getCosDictionary().getDouble(ASName.k_MaxWidth);
        }
        return 0.0;
    }

    double getMissingWidth() {
        if (this.getCosDictionary().containsKey(ASName.k_MissingWidth)) {
            return this.getCosDictionary().getDouble(ASName.k_MissingWidth);
        }
        return 0.0;
    }

    PDFCosObject getFontFile() {
        if (this.getCosDictionary().containsKey(ASName.k_FontFile)) {
            return (PDFFontFile)PDFFontFile.instantiate(this.getCosDictionary().get(ASName.k_FontFile));
        }
        return null;
    }

    PDFCosObject getFontFile2() {
        if (this.getCosDictionary().containsKey(ASName.k_FontFile2)) {
            return (PDFFontFile)PDFFontFile.instantiate(this.getCosDictionary().get(ASName.k_FontFile2));
        }
        return null;
    }

    PDFCosObject getFontFile3() {
        if (this.getCosDictionary().containsKey(ASName.k_FontFile3)) {
            return (PDFFontFile)PDFFontFile.instantiate(this.getCosDictionary().get(ASName.k_FontFile3));
        }
        return null;
    }

    ASString getCharSet() {
        if (this.getCosDictionary().containsKey(ASName.k_CharSet)) {
            return this.getCosDictionary().getString(ASName.k_CharSet);
        }
        return null;
    }

    PDFCIDFontStyle getStyle() {
        if (this.getCosDictionary().containsKey(ASName.k_Style)) {
            return (PDFCIDFontStyle)PDFCIDFontStyle.instantiate(this.getCosDictionary().get(ASName.k_Style));
        }
        return null;
    }

    ASName getLang() {
        if (this.getCosDictionary().containsKey(ASName.k_Lang)) {
            return this.getCosDictionary().getName(ASName.k_Lang);
        }
        return null;
    }

    ArrayList getFDKeys() {
        if (this.getCosDictionary().containsKey(ASName.k_FD)) {
            return this.getCosDictionary().getCosDictionary(ASName.k_FD).getKeys();
        }
        return null;
    }

    PDFFontDescriptor getFD(ASName aSName) {
        if (this.getCosDictionary().containsKey(ASName.k_FD)) {
            CosDictionary cosDictionary = this.getCosDictionary().getCosDictionary(ASName.k_FD);
            if (cosDictionary.containsKey(aSName)) {
                return PDFFontDescriptor.instantiate(cosDictionary.get(aSName));
            }
            return null;
        }
        return null;
    }

    ByteStream getCIDSet() {
        if (this.getCosDictionary().containsKey(ASName.k_CIDSet)) {
            return this.getCosDictionary().getStream(ASName.k_CIDSet);
        }
        return null;
    }
}

