/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class PDFContents
extends PDFCosObject
implements PDFInstantiate {
    PDFContents(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFContents", cosObject);
    }

    public PDFContentStreamsIterator iterator() {
        return new PDFContentStreamsIterator();
    }

    public PDFContentStreamsIterator listIterator() {
        return new PDFContentStreamsIterator();
    }

    public class PDFContentStreamsIterator
    implements ListIterator {
        private boolean isArray;
        private int arraySize;
        private int nextIndex;
        private ListIterator arrayIter;

        PDFContentStreamsIterator() {
            if (PDFContents.this.getCosObject() instanceof CosArray) {
                this.isArray = true;
                this.arraySize = PDFContents.this.getCosArray().size();
                this.arrayIter = PDFContents.this.getCosArray().listIterator();
            } else if (PDFContents.this.getCosObject() instanceof CosStream) {
                this.isArray = false;
                this.arraySize = 1;
                this.arrayIter = null;
            } else {
                this.isArray = false;
                this.arraySize = 0;
                this.arrayIter = null;
            }
            this.nextIndex = 0;
        }

        public int previousIndex() {
            if (this.isArray) {
                return this.arrayIter.previousIndex();
            }
            return this.nextIndex > 0 ? 0 : -1;
        }

        public int nextIndex() {
            if (this.isArray) {
                return this.arrayIter.nextIndex();
            }
            return this.nextIndex < this.arraySize ? this.nextIndex : this.arraySize;
        }

        public boolean hasNext() {
            if (this.isArray) {
                return this.arrayIter.hasNext();
            }
            return this.nextIndex < this.arraySize;
        }

        public Object next() {
            if (this.isArray) {
                return ((CosStream)this.arrayIter.next()).getStream();
            }
            if (this.hasNext()) {
                ++this.nextIndex;
                return PDFContents.this.getCosStream().getStream();
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            if (this.isArray) {
                return this.arrayIter.hasPrevious();
            }
            return this.nextIndex > 0;
        }

        public Object previous() {
            if (this.isArray) {
                return ((CosStream)this.arrayIter.previous()).getStream();
            }
            if (this.hasPrevious()) {
                --this.nextIndex;
                return PDFContents.this.getCosStream().getStream();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

