/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.DisplacementEntry;
import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosObject;
import java.util.HashSet;
import java.util.Iterator;

public class PDFCIDVerticalMetrics
extends PDFCosObject
implements PDFInstantiate {
    private HashSet metrics;
    private int cachedCID;
    private DisplacementEntry cachedEntry;

    PDFCIDVerticalMetrics(CosObject cosObject) {
        super(cosObject);
        this.buildMetricsTable();
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFCIDVerticalMetrics", cosObject);
    }

    public boolean containsMetric(int n) {
        return this.getEntry(n) != null;
    }

    public double[] getMetrics(int n) {
        DisplacementEntry displacementEntry = this.getEntry(n);
        if (displacementEntry != null) {
            return displacementEntry.getMetrics(n);
        }
        return null;
    }

    public double getVerticalDisplacement(int n) {
        DisplacementEntry displacementEntry = this.getEntry(n);
        if (displacementEntry != null) {
            return displacementEntry.getVerticalDisplacement(n);
        }
        return 0.0;
    }

    public double[] getPositionVector(int n) {
        DisplacementEntry displacementEntry = this.getEntry(n);
        if (displacementEntry != null) {
            return displacementEntry.getPositionVector(n);
        }
        return null;
    }

    private DisplacementEntry getEntry(int n) {
        if (n == this.cachedCID) {
            return this.cachedEntry;
        }
        Iterator iterator = this.metrics.iterator();
        while (iterator.hasNext()) {
            DisplacementEntry displacementEntry = (DisplacementEntry)iterator.next();
            if (!displacementEntry.contains(n)) continue;
            this.cachedCID = n;
            this.cachedEntry = displacementEntry;
            return displacementEntry;
        }
        return null;
    }

    private void buildMetricsTable() {
        if (this.metrics == null) {
            Iterator iterator = this.getCosArray().iterator();
            while (iterator.hasNext()) {
                int n = ((Number)iterator.next()).intValue();
                CosObject cosObject = (CosObject)iterator.next();
                if (cosObject instanceof CosArray) {
                    this.metrics.add(new DisplacementEntry(n, (CosArray)cosObject));
                    continue;
                }
                int n2 = ((Number)((Object)cosObject)).intValue();
                double d = ((Number)iterator.next()).doubleValue();
                double d2 = ((Number)iterator.next()).doubleValue();
                double d3 = ((Number)iterator.next()).doubleValue();
                this.metrics.add(new DisplacementEntry(n, n2, d, d2, d3));
            }
        }
    }
}

