/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.WidthEntry;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosNumeric;
import com.adobe.internal.pdf.cos.CosObject;
import java.util.HashSet;
import java.util.Iterator;

public class PDFCIDFontWidths
extends PDFCosObject
implements PDFInstantiate {
    private HashSet widths;
    private int cachedCID;
    private WidthEntry cachedEntry;

    PDFCIDFontWidths(CosObject cosObject) {
        super(cosObject);
        this.buildWidthsTable();
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFCIDFontWidths", cosObject);
    }

    public boolean containsWidth(int n) {
        return this.getEntry(n) != null;
    }

    public double getWidth(int n) {
        WidthEntry widthEntry = this.getEntry(n);
        if (widthEntry != null) {
            return widthEntry.getWidth(n);
        }
        return 0.0;
    }

    private WidthEntry getEntry(int n) {
        if (n == this.cachedCID) {
            return this.cachedEntry;
        }
        Iterator iterator = this.widths.iterator();
        while (iterator.hasNext()) {
            WidthEntry widthEntry = (WidthEntry)iterator.next();
            if (!widthEntry.contains(n)) continue;
            this.cachedCID = n;
            this.cachedEntry = widthEntry;
            return widthEntry;
        }
        return null;
    }

    private void buildWidthsTable() {
        if (this.widths == null) {
            this.widths = new HashSet();
            Iterator iterator = this.getCosArray().iterator();
            while (iterator.hasNext()) {
                int n = ((CosNumeric)iterator.next()).intValue();
                CosObject cosObject = (CosObject)iterator.next();
                if (cosObject instanceof CosArray) {
                    this.widths.add(new WidthEntry(n, (CosArray)cosObject));
                    continue;
                }
                int n2 = ((CosNumeric)cosObject).intValue();
                double d = ((CosNumeric)iterator.next()).doubleValue();
                this.widths.add(new WidthEntry(n, n2, d));
            }
        }
    }
}

