/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCIDFontWidths;
import com.adobe.internal.pdf.PDFCIDSystemInfo;
import com.adobe.internal.pdf.PDFCIDVerticalMetrics;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFFontDescriptor;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;

public abstract class PDFCIDFont
extends PDFCosObject {
    PDFCIDFont(CosObject cosObject) {
        super(cosObject);
    }

    public ASName getBaseFont() {
        return this.getCosDictionary().getName(ASName.k_BaseFont);
    }

    PDFCIDSystemInfo getCIDSystemInfo() {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_CIDSystemInfo);
        return (PDFCIDSystemInfo)PDFCIDSystemInfo.instantiate(cosObject);
    }

    PDFFontDescriptor getFontDescriptor() {
        CosDictionary cosDictionary = this.getCosDictionary().getCosDictionary(ASName.k_FontDescriptor);
        return PDFFontDescriptor.instantiate(cosDictionary);
    }

    int getDW() {
        int n = 1000;
        if (this.getCosDictionary().containsKey(ASName.k_DW)) {
            return this.getCosDictionary().getInt(ASName.k_DW);
        }
        return n;
    }

    PDFCIDFontWidths getW() {
        CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_W);
        return (PDFCIDFontWidths)PDFCIDFontWidths.instantiate(cosArray);
    }

    int[] getDW2() {
        int[] nArray = new int[2];
        if (this.getCosDictionary().containsKey(ASName.k_DW2)) {
            CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_DW2);
            nArray[0] = cosArray.getInt(0);
            nArray[1] = cosArray.getInt(1);
        } else {
            nArray[0] = 880;
            nArray[1] = -1000;
        }
        return nArray;
    }

    PDFCIDVerticalMetrics getW2() {
        CosArray cosArray = this.getCosDictionary().getCosArray(ASName.k_W2);
        return (PDFCIDVerticalMetrics)PDFCIDVerticalMetrics.instantiate(cosArray);
    }
}

