/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.Utility;
import java.util.ArrayList;

public class PDFBorderStyle
extends PDFCosObject
implements PDFInstantiate {
    PDFBorderStyle(CosObject cosObject) {
        super(cosObject);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFBorderStyle", cosObject);
    }

    static PDFBorderStyle create(PDFDocument pDFDocument, double d, ASName aSName, long[] lArray) {
        PDFCosObject pDFCosObject = (PDFCosObject)PDFCosFactory.newDictionary(pDFDocument, "PDFBorderStyle");
        CosDictionary cosDictionary = pDFCosObject.getCosDictionary();
        cosDictionary.put(ASName.k_Type, ASName.k_Border);
        cosDictionary.put(ASName.k_W, d);
        cosDictionary.put(ASName.k_S, aSName);
        cosDictionary.put(ASName.k_D, lArray);
        return (PDFBorderStyle)pDFCosObject;
    }

    static PDFBorderStyle create(PDFDocument pDFDocument) {
        PDFCosObject pDFCosObject = (PDFCosObject)PDFCosFactory.newDictionary(pDFDocument, "PDFBorderStyle");
        return (PDFBorderStyle)pDFCosObject;
    }

    public double getWidth() {
        return this.getDictionaryNumericValue(ASName.k_W).doubleValue();
    }

    public String getWidthAsString() {
        return this.getDictionaryDoubleValueAsString(ASName.k_W);
    }

    public void setWidth(String string) {
        this.setDictionaryDoubleValue(ASName.k_W, string);
    }

    public boolean hasWidth() {
        return this.dictionaryContains(ASName.k_W);
    }

    public ASName getStyle() {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setStyle(String string) {
        this.setDictionaryNameValue(ASName.k_S, string);
    }

    public boolean hasStyle() {
        return this.dictionaryContains(ASName.k_S);
    }

    public double[] getDash() {
        CosArray cosArray = (CosArray)this.getValue(ASName.k_D);
        return cosArray.getArrayDouble();
    }

    public void setDash(String string, String string2) {
        ArrayList arrayList = Utility.parseNumbers(string, string2);
        if (arrayList != null) {
            this.setDictionaryArrayValue(ASName.k_D, arrayList);
        }
    }

    public boolean hasDash() {
        return this.dictionaryContains(ASName.k_D);
    }
}

