/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFAnnotationCircle;
import com.adobe.internal.pdf.PDFAnnotationFileAttachment;
import com.adobe.internal.pdf.PDFAnnotationFreeText;
import com.adobe.internal.pdf.PDFAnnotationHighlight;
import com.adobe.internal.pdf.PDFAnnotationInk;
import com.adobe.internal.pdf.PDFAnnotationLine;
import com.adobe.internal.pdf.PDFAnnotationLink;
import com.adobe.internal.pdf.PDFAnnotationMovie;
import com.adobe.internal.pdf.PDFAnnotationPopup;
import com.adobe.internal.pdf.PDFAnnotationSound;
import com.adobe.internal.pdf.PDFAnnotationSquare;
import com.adobe.internal.pdf.PDFAnnotationSquiggly;
import com.adobe.internal.pdf.PDFAnnotationStamp;
import com.adobe.internal.pdf.PDFAnnotationStrikeOut;
import com.adobe.internal.pdf.PDFAnnotationText;
import com.adobe.internal.pdf.PDFAnnotationUnderline;
import com.adobe.internal.pdf.PDFAnnotationWidget;
import com.adobe.internal.pdf.PDFBorderEffects;
import com.adobe.internal.pdf.PDFBorderStyle;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFPage;
import com.adobe.internal.pdf.PDFRectangle;
import com.adobe.internal.pdf.PDFText;
import com.adobe.internal.pdf.cos.CosArray;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosDocument;
import com.adobe.internal.pdf.cos.CosName;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.CosStream;
import com.adobe.internal.pdf.cos.util.ASDate;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.ByteArrayByteRepository;
import com.adobe.internal.pdf.cos.util.ByteBuffer;
import com.adobe.internal.pdf.cos.util.Utility;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PDFAnnotation
extends PDFCosObject
implements PDFInstantiate {
    public static final int kInvisible = 1;
    public static final int kHidden = 2;
    public static final int kPrint = 4;
    public static final int kNoZoom = 8;
    public static final int kNoRotate = 16;
    public static final int kNoView = 32;
    public static final int kReadOnly = 64;
    public static final int kLocked = 128;
    public static final int kToggleNoView = 256;

    PDFAnnotation(CosObject cosObject) {
        super(cosObject);
    }

    static void initialize(CosDictionary cosDictionary) {
        cosDictionary.put(ASName.k_Type, ASName.k_Annot);
    }

    static Object instantiate(CosObject cosObject) {
        if (cosObject == null) {
            return null;
        }
        CosName cosName = (CosName)((CosDictionary)cosObject).get(ASName.k_Subtype);
        ASName aSName = cosName.nameValue();
        if (aSName == ASName.k_Text) {
            return PDFAnnotationText.instantiate(cosObject);
        }
        if (aSName == ASName.k_Link) {
            return PDFAnnotationLink.instantiate(cosObject);
        }
        if (aSName == ASName.k_FreeText) {
            return PDFAnnotationFreeText.instantiate(cosObject);
        }
        if (aSName == ASName.k_Line) {
            return PDFAnnotationLine.instantiate(cosObject);
        }
        if (aSName == ASName.k_Square) {
            return PDFAnnotationSquare.instantiate(cosObject);
        }
        if (aSName == ASName.k_Circle) {
            return PDFAnnotationCircle.instantiate(cosObject);
        }
        if (aSName == ASName.k_Highlight) {
            return PDFAnnotationHighlight.instantiate(cosObject);
        }
        if (aSName == ASName.k_Underline) {
            return PDFAnnotationUnderline.instantiate(cosObject);
        }
        if (aSName == ASName.k_Squiggly) {
            return PDFAnnotationSquiggly.instantiate(cosObject);
        }
        if (aSName == ASName.k_StrikeOut) {
            return PDFAnnotationStrikeOut.instantiate(cosObject);
        }
        if (aSName == ASName.k_Stamp) {
            return PDFAnnotationStamp.instantiate(cosObject);
        }
        if (aSName == ASName.k_Ink) {
            return PDFAnnotationInk.instantiate(cosObject);
        }
        if (aSName == ASName.k_Popup) {
            return PDFAnnotationPopup.instantiate(cosObject);
        }
        if (aSName == ASName.k_FileAttachment) {
            return PDFAnnotationFileAttachment.instantiate(cosObject);
        }
        if (aSName == ASName.k_Sound) {
            return PDFAnnotationSound.instantiate(cosObject);
        }
        if (aSName == ASName.k_Movie) {
            return PDFAnnotationMovie.instantiate(cosObject);
        }
        if (aSName == ASName.k_Widget) {
            return PDFAnnotationWidget.instantiate(cosObject);
        }
        return null;
    }

    PDFRectangle getLocation() {
        return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_Rect));
    }

    void setLocation(PDFRectangle pDFRectangle) {
        this.setValue(ASName.k_Rect, pDFRectangle.getCosObject());
    }

    public boolean hasRectangle() {
        return this.dictionaryContains(ASName.k_Rect);
    }

    public PDFRectangle getRectangle() {
        return (PDFRectangle)PDFRectangle.instantiate(this.getValue(ASName.k_Rect));
    }

    public void setRectangle(double d, double d2, double d3, double d4) {
        ArrayList<Double> arrayList = new ArrayList<Double>(4);
        arrayList.add(0, new Double(d));
        arrayList.add(1, new Double(d2));
        arrayList.add(2, new Double(d3));
        arrayList.add(3, new Double(d4));
        this.setDictionaryArrayValue(ASName.k_Rect, arrayList);
    }

    public String getContents() {
        return this.getDictionaryTextStringValue(ASName.k_Contents);
    }

    public String getRichContents() {
        return this.getDictionaryTextStringOrStreamValue(ASName.k_RC);
    }

    PDFPage getPage() {
        return (PDFPage)PDFPage.instantiate(this.getValue(ASName.k_Page));
    }

    boolean hasName() {
        return this.dictionaryContains(ASName.k_NM);
    }

    public String getName() {
        return this.getDictionaryTextStringValue(ASName.k_NM);
    }

    public void setName(String string) {
        PDFText pDFText = PDFText.createString(this.getPDFDocument(), string);
        this.setDictionaryTextValue(ASName.k_NM, pDFText);
    }

    public boolean hasIcon() {
        return this.dictionaryContains(ASName.k_Name);
    }

    public String getIcon() {
        return this.getDictionaryNameValue(ASName.k_Name).toString();
    }

    public void setIcon(String string) {
        this.setDictionaryNameValue(ASName.k_Name, string);
    }

    public ASDate getModificationDate() {
        return this.getDictionaryDateValue(ASName.k_M);
    }

    public void setModificationDate(String string) {
        PDFText pDFText = PDFText.createString(this.getPDFDocument(), string);
        this.setDictionaryTextValue(ASName.k_M, pDFText);
    }

    public boolean hasModificationDate() {
        return this.dictionaryContains(ASName.k_M);
    }

    public String getTitle() {
        return this.getDictionaryTextStringValue(ASName.k_T);
    }

    public PDFAnnotationPopup getAnnotationPopup() {
        return (PDFAnnotationPopup)PDFAnnotationPopup.instantiate(this.getValue(ASName.k_Popup));
    }

    public boolean hasPopup() {
        return this.dictionaryContains(ASName.k_Popup);
    }

    public PDFBorderStyle getBorderStyle() {
        return (PDFBorderStyle)PDFBorderStyle.instantiate(this.getValue(ASName.k_BS));
    }

    public PDFBorderStyle getOrMakeBorderStyle() {
        PDFBorderStyle pDFBorderStyle = this.getBorderStyle();
        if (pDFBorderStyle == null) {
            pDFBorderStyle = PDFBorderStyle.create(this.getPDFDocument());
        }
        return pDFBorderStyle;
    }

    public void setBorderStyle(PDFBorderStyle pDFBorderStyle) {
        this.setDictionaryDictionaryValue(ASName.k_BS, pDFBorderStyle.getCosDictionary());
    }

    public PDFBorderEffects getBorderEffects() {
        return (PDFBorderEffects)PDFBorderEffects.instantiate(this.getValue(ASName.k_BE));
    }

    public PDFBorderEffects getOrMakeBorderEffects() {
        PDFBorderEffects pDFBorderEffects = this.getBorderEffects();
        if (pDFBorderEffects == null) {
            pDFBorderEffects = PDFBorderEffects.create(this.getPDFDocument());
        }
        return pDFBorderEffects;
    }

    public void setBorderEffects(PDFBorderEffects pDFBorderEffects) {
        this.setDictionaryDictionaryValue(ASName.k_BE, pDFBorderEffects.getCosDictionary());
    }

    public double[] getFringe() {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_RD);
        return cosArray.getArrayDouble();
    }

    public void setFringe(String string, String string2) {
        this.setDictionaryArrayValue(ASName.k_RD, Utility.parseNumbers(string, string2));
    }

    public boolean hasFringe() {
        return this.dictionaryContains(ASName.k_RD);
    }

    public double[] getQuadPoints() {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_QuadPoints);
        return cosArray.getArrayDouble();
    }

    public void setQuadPoints(String string, String string2) {
        this.setDictionaryArrayValue(ASName.k_QuadPoints, Utility.parseNumbers(string, string2));
    }

    public boolean hasQuadPoints() {
        return this.dictionaryContains(ASName.k_QuadPoints);
    }

    public boolean hasParent() {
        return this.dictionaryContains(ASName.k_P);
    }

    public void setParent(PDFPage pDFPage) {
        this.setDictionaryDictionaryValue(ASName.k_P, pDFPage.getCosDictionary());
    }

    public String getDefaultStyle() {
        return this.getDictionaryTextStringValue(ASName.k_DS);
    }

    public void setDefaultStyle(String string) {
        this.setDictionaryStringValue(ASName.k_DS, string);
    }

    public String getDefaultAppearance() {
        return this.getDictionaryTextStringValue(ASName.k_DA);
    }

    public void setDefaultAppearance(String string) {
        this.setDictionaryStringValue(ASName.k_DA, string);
    }

    public int getFlags() {
        if (this.dictionaryContains(ASName.k_F)) {
            return this.getDictionaryIntValue(ASName.k_F);
        }
        return 0;
    }

    public String getOpacity() {
        return this.getDictionaryDoubleValueAsString(ASName.k_CA);
    }

    public boolean hasOpacity() {
        return this.dictionaryContains(ASName.k_CA);
    }

    public void setOpacity(String string) {
        this.setDictionaryDoubleValue(ASName.k_CA, string);
    }

    public String getSubject() {
        return this.getDictionaryTextStringValue(ASName.k_Subj);
    }

    public void setSubject(String string) {
        this.setDictionaryStringValue(ASName.k_Subj, string);
    }

    public boolean hasSubject() {
        return this.dictionaryContains(ASName.k_Subj);
    }

    public boolean hasRotation() {
        return this.dictionaryContains(ASName.k_Rotate);
    }

    public int getRotation() {
        return this.getDictionaryIntValue(ASName.k_Rotate);
    }

    public void setRotation(String string) {
        this.setDictionaryIntValue(ASName.k_Rotate, string);
    }

    public void setRGBColor(String string) {
        this.setRGBColorFromXML(ASName.k_C, string);
    }

    public void setRGBInteriorColor(String string) {
        this.setRGBColorFromXML(ASName.k_IC, string);
    }

    private void setRGBColorFromXML(ASName aSName, String string) {
        if (string.length() != 7) {
            return;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(3);
        Integer n = new Integer(Integer.parseInt(string.substring(1, 3), 16));
        arrayList.add(0, new Double(n.doubleValue() / 255.0));
        Integer n2 = new Integer(Integer.parseInt(string.substring(3, 5), 16));
        arrayList.add(1, new Double(n2.doubleValue() / 255.0));
        Integer n3 = new Integer(Integer.parseInt(string.substring(5, 7), 16));
        arrayList.add(2, new Double(n3.doubleValue() / 255.0));
        this.setDictionaryArrayValue(aSName, arrayList);
    }

    public ASDate getCreationDate() {
        return this.getDictionaryDateValue(ASName.k_CreationDate);
    }

    public void setCreationDate(String string) {
        PDFText pDFText = PDFText.createString(this.getPDFDocument(), string);
        this.setDictionaryTextValue(ASName.k_CreationDate, pDFText);
    }

    public boolean hasCreationDate() {
        return this.dictionaryContains(ASName.k_CreationDate);
    }

    public void setTitle(String string) {
        PDFText pDFText = PDFText.createString(this.getPDFDocument(), string);
        this.setDictionaryTextValue(ASName.k_T, pDFText);
    }

    public void setFlags(int n) {
        if (n != 0) {
            this.setDictionaryIntValue(ASName.k_F, n);
        }
    }

    public void setContents(String string) {
        this.setDictionaryStringValue(ASName.k_Contents, string);
    }

    public void setRichContents(String string) {
        this.setDictionaryStringOrStreamValue(ASName.k_RC, string);
    }

    public void setStreamFilter(CosStream cosStream, String string) {
        cosStream.put(ASName.k_Filter, ASName.create(string));
    }

    public void setStreamFilter(CosStream cosStream, ArrayList arrayList) {
        ArrayList<CosName> arrayList2 = new ArrayList<CosName>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        CosDocument cosDocument = this.getPDFDocument().getDocument();
        while (iterator.hasNext()) {
            ASName aSName = ASName.create((String)iterator.next());
            arrayList2.add(cosDocument.newName(aSName));
        }
        cosStream.put(ASName.k_Filter, this.getPDFDocument().getDocument().newArray(arrayList2));
    }

    public void setStreamLength(CosStream cosStream, int n) {
        cosStream.put(ASName.k_Length, n);
    }

    public void setDataStream(CosStream cosStream, byte[] byArray) {
        if (cosStream != null) {
            cosStream.newData(new ByteBuffer(new ByteArrayByteRepository(byArray)));
        }
    }

    public void setDataStreamEncoded(CosStream cosStream, byte[] byArray) {
        if (cosStream != null) {
            cosStream.newDataEncoded(new ByteBuffer(new ByteArrayByteRepository(byArray)));
        }
    }

    public void setAnnotationPopup(PDFAnnotationPopup pDFAnnotationPopup) {
        this.setDictionaryDictionaryValue(ASName.k_Popup, pDFAnnotationPopup.getCosDictionary());
    }

    boolean supportsXFDF() {
        return this instanceof PDFAnnotationText || this instanceof PDFAnnotationCircle || this instanceof PDFAnnotationFileAttachment || this instanceof PDFAnnotationFreeText || this instanceof PDFAnnotationHighlight || this instanceof PDFAnnotationInk || this instanceof PDFAnnotationLine || this instanceof PDFAnnotationLink || this instanceof PDFAnnotationSound || this instanceof PDFAnnotationSquare || this instanceof PDFAnnotationStrikeOut || this instanceof PDFAnnotationUnderline;
    }

    boolean isFlagged(int n) {
        return (this.getFlags() & n) != 0;
    }
}

