/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.PDFCosFactory;
import com.adobe.internal.pdf.PDFCosObject;
import com.adobe.internal.pdf.PDFDestination;
import com.adobe.internal.pdf.PDFDocument;
import com.adobe.internal.pdf.PDFFileSpecification;
import com.adobe.internal.pdf.PDFInstantiate;
import com.adobe.internal.pdf.PDFText;
import com.adobe.internal.pdf.cos.CosDictionary;
import com.adobe.internal.pdf.cos.CosObject;
import com.adobe.internal.pdf.cos.util.ASName;
import com.adobe.internal.pdf.cos.util.PDFDocEncoding;

public class PDFActions
extends PDFCosObject
implements PDFInstantiate {
    private CosDictionary actionDict;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_LAUNCH = 1;
    public static final int ACTION_GOTO = 2;
    public static final int ACTION_GOTOR = 3;
    public static final int ACTION_NAMED = 4;
    public static final int ACTION_URI = 5;

    private PDFActions(CosObject cosObject) {
        super(cosObject);
    }

    static PDFActions create(CosObject cosObject) {
        PDFActions pDFActions = new PDFActions(cosObject);
        pDFActions.actionDict = (CosDictionary)cosObject;
        return pDFActions;
    }

    public static PDFActions create(PDFDocument pDFDocument) {
        CosDictionary cosDictionary = pDFDocument.getDocument().newDictionary();
        cosDictionary.put(ASName.k_Type, ASName.k_Action);
        return PDFActions.create(cosDictionary);
    }

    static Object instantiate(CosObject cosObject) {
        return PDFCosFactory.instantiate("PDFActions", cosObject);
    }

    public int getType() {
        int n = 0;
        ASName aSName = this.actionDict.getName(ASName.k_S);
        if (aSName != null) {
            n = aSName.equals(ASName.k_GoTo) ? 2 : (aSName.equals(ASName.k_GoToR) ? 3 : (aSName.equals(ASName.k_Named) ? 4 : (aSName.equals(ASName.k_Launch) ? 1 : (aSName.equals(ASName.k_URI) ? 5 : 0))));
        }
        return n;
    }

    public String getTypeAsString() {
        if (this.getType() == 0) {
            return null;
        }
        return this.actionDict.getName(ASName.k_S).toString();
    }

    public void setType(String string) {
        this.setDictionaryNameValue(ASName.k_S, string);
    }

    public boolean hasNewWindow() {
        return this.actionDict.containsKey(ASName.k_NewWindow);
    }

    public String getNewWindow() {
        if (this.getType() == 1 && this.hasNewWindow()) {
            return Boolean.toString(this.actionDict.getBoolean(ASName.k_NewWindow));
        }
        return null;
    }

    public void setNewWindow(String string) {
        this.setDictionaryBooleanValue(ASName.k_NewWindow, string);
    }

    public String getURI() {
        if (this.getType() == 5) {
            PDFText pDFText = new PDFText(this.actionDict.getCosString(ASName.k_URI));
            return pDFText.stringValue();
        }
        return null;
    }

    public void setURI(String string) {
        this.setDictionaryStringValue(ASName.k_URI, string);
    }

    public boolean hasIsMap() {
        return this.actionDict.containsKey(ASName.k_IsMap);
    }

    public boolean getIsMap() {
        return this.hasIsMap() ? this.actionDict.getBoolean(ASName.k_IsMap) : false;
    }

    public void setIsMap(String string) {
        this.setDictionaryBooleanValue(ASName.k_IsMap, string);
    }

    public void setIsMap(boolean bl) {
        this.setDictionaryBooleanValue(ASName.k_IsMap, bl);
    }

    public boolean hasNamed() {
        return this.actionDict.containsKey(ASName.k_N);
    }

    public ASName getNamed() {
        return this.hasNamed() ? this.actionDict.getName(ASName.k_N) : null;
    }

    public void setNamed(String string) {
        this.setDictionaryNameValue(ASName.k_N, string);
    }

    public void setNamed(ASName aSName) {
        this.setDictionaryNameValue(ASName.k_N, aSName);
    }

    public PDFDestination getDestination() {
        if (this.getType() == 2 && this.actionDict.containsKey(ASName.k_D)) {
            return new PDFDestination(this.actionDict.get(ASName.k_D));
        }
        return null;
    }

    public void setDestination(PDFDestination pDFDestination) {
        this.setDictionaryValue(ASName.k_D, pDFDestination.getCosObject());
    }

    public boolean hasFileSpecification() {
        return this.dictionaryContains(ASName.k_F);
    }

    public PDFFileSpecification getFileSpecification() {
        return this.hasFileSpecification() ? new PDFFileSpecification(this.getDictionaryDictionaryValue(ASName.k_F)) : null;
    }

    public void setFileSpecification(PDFFileSpecification pDFFileSpecification) {
        this.setDictionaryDictionaryValue(ASName.k_F, pDFFileSpecification.getCosDictionary());
    }

    public String getFilename() {
        PDFFileSpecification pDFFileSpecification = this.getFileSpecification();
        if (pDFFileSpecification == null) {
            return null;
        }
        byte[] byArray = pDFFileSpecification.getFilename().getBytes();
        return PDFDocEncoding.toEscapeString(byArray, 0, byArray.length);
    }
}

