/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import com.adobe.internal.pdf.cos.CosArray;

class DisplacementEntry {
    private int startCID;
    private int endCID;
    private Object metrics;

    DisplacementEntry(int n, CosArray cosArray) {
        this.startCID = n;
        this.endCID = n + cosArray.size() / 3;
        this.metrics = cosArray;
    }

    DisplacementEntry(int n, int n2, double d, double d2, double d3) {
        this.startCID = n;
        this.endCID = n2;
        this.metrics = new double[3];
        ((double[])this.metrics)[0] = d;
        ((double[])this.metrics)[1] = d2;
        ((double[])this.metrics)[2] = d3;
    }

    int getStartCID() {
        return this.startCID;
    }

    int getEndCID() {
        return this.endCID;
    }

    boolean contains(int n) {
        return n >= this.startCID && n <= this.endCID;
    }

    double[] getMetrics(int n) {
        double[] dArray = new double[3];
        if (this.metrics instanceof CosArray) {
            int n2 = (n - this.startCID) * 3;
            dArray[0] = ((CosArray)this.metrics).getDouble(n2);
            dArray[1] = ((CosArray)this.metrics).getDouble(n2 + 1);
            dArray[2] = ((CosArray)this.metrics).getDouble(n2 + 2);
        } else {
            dArray = (double[])this.metrics;
        }
        return dArray;
    }

    double getVerticalDisplacement(int n) {
        int n2 = (n - this.startCID) * 3;
        if (this.metrics instanceof CosArray) {
            return ((CosArray)this.metrics).getDouble(n2);
        }
        return ((double[])this.metrics)[0];
    }

    double[] getPositionVector(int n) {
        double[] dArray = new double[2];
        if (this.metrics instanceof CosArray) {
            int n2 = (n - this.startCID) * 3;
            dArray[0] = ((CosArray)this.metrics).getDouble(n2 + 1);
            dArray[1] = ((CosArray)this.metrics).getDouble(n2 + 2);
        } else {
            dArray[0] = ((double[])this.metrics)[1];
            dArray[1] = ((double[])this.metrics)[2];
        }
        return dArray;
    }
}

