/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

class CMapCodeMapping
implements Comparable {
    private int startCode;
    private int endCode;
    private ArrayList data;

    CMapCodeMapping(int n) {
        this.startCode = n;
        this.endCode = n;
        this.data = new ArrayList();
    }

    CMapCodeMapping(int n, int n2) {
        this.startCode = n;
        this.endCode = n2;
        this.data = new ArrayList();
    }

    void addHexData(byte[] byArray) {
        this.data.add(byArray);
    }

    void addCharName(String string) {
        this.data.add(string);
    }

    int getStartCode() {
        return this.startCode;
    }

    int getEndCode() {
        return this.endCode;
    }

    boolean contains(int n) {
        return n >= this.startCode && n <= this.endCode;
    }

    boolean isHexData(int n) {
        if (this.data.size() == 1) {
            return this.data.get(0) instanceof byte[];
        }
        return this.data.get(n) instanceof byte[];
    }

    boolean isCharName(int n) {
        return !this.isHexData(n);
    }

    byte[] getHexData(int n) {
        if (this.data.size() == 1) {
            return (byte[])this.data.get(0);
        }
        return (byte[])this.data.get(n);
    }

    char[] getHexDataAsCharArray(int n) {
        byte[] byArray;
        if (this.data.size() == 1) {
            byArray = (byte[])this.data.get(0);
            if (n > this.startCode) {
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                int n2 = 0xFF & byArray[byArray.length - 1];
                byArray2[byArray.length - 1] = (byte)((n2 += n - this.startCode) & 0xFF);
                byArray = byArray2;
            }
        } else {
            byArray = (byte[])this.data.get(n);
        }
        return CMapCodeMapping.getCharsFromBytes(byArray);
    }

    private static char[] getCharsFromBytes(byte[] byArray) {
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length / 2];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(((byArray[i * 2] & 0xFF) << 8) + (byArray[i * 2 + 1] & 0xFF));
            }
        }
        return cArray;
    }

    String getCharName(int n) {
        if (this.data.size() == 1) {
            return (String)this.data.get(0);
        }
        return (String)this.data.get(n);
    }

    public int compareTo(CMapCodeMapping cMapCodeMapping) {
        int n = this.startCode;
        int n2 = cMapCodeMapping.startCode;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((CMapCodeMapping)object);
    }

    public String toString() {
        String string = "<" + String.valueOf(this.startCode) + "> <" + String.valueOf(this.endCode) + "> ";
        String string2 = "";
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof byte[]) {
                try {
                    string2 = "\"" + new String((byte[])e, "UTF-16BE") + "\"";
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = "<character description with unknown encoding>";
                }
                continue;
            }
            if (!(e instanceof String)) continue;
            string2 = (String)e;
        }
        return string + string2;
    }
}

