/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.xmputility.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.livecycle.xmputility.client.XMPUtilityException;
import com.adobe.livecycle.xmputility.client.XMPUtilityMetadata;
import java.util.HashMap;

public class XMPUtilityServiceClient {
    private ServiceClientFactory serviceClientFactory;

    public XMPUtilityServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceClientFactory = serviceClientFactory;
    }

    public String getVersion() {
        HashMap input = new HashMap();
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("XMPUtilityService", "getVersion", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof String)) continue;
                return (String)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document importXMP(Document pdf, Document xmp) throws XMPUtilityException {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inPDFDoc", pdf);
        input.put("xmp", xmp);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("XMPUtilityService", "importXMP", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof XMPUtilityException) {
                throw (XMPUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document exportXMP(Document pdf) throws XMPUtilityException {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inPDFDoc", pdf);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("XMPUtilityService", "exportXMP", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof XMPUtilityException) {
                throw (XMPUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document importMetadata(Document pdf, XMPUtilityMetadata metadata) throws XMPUtilityException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("inPDFDoc", pdf);
        input.put("metadata", metadata);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("XMPUtilityService", "importMetadata", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof XMPUtilityException) {
                throw (XMPUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public XMPUtilityMetadata exportMetadata(Document pdf) throws XMPUtilityException {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inPDFDoc", pdf);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("XMPUtilityService", "exportMetadata", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof XMPUtilityMetadata)) continue;
                return (XMPUtilityMetadata)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof XMPUtilityException) {
                throw (XMPUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }
}

