/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.pdfutility.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.livecycle.pdfutility.client.PDFPropertiesOptionSpec;
import com.adobe.livecycle.pdfutility.client.PDFPropertiesResult;
import com.adobe.livecycle.pdfutility.client.PDFUtilityException;
import com.adobe.livecycle.pdfutility.client.PDFUtilitySaveMode;
import java.util.HashMap;
import java.util.List;

public class PDFUtilityServiceClient {
    private ServiceClientFactory serviceClientFactory;

    public PDFUtilityServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceClientFactory = serviceClientFactory;
    }

    public String getVersion() {
        HashMap input = new HashMap();
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "getVersion", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof String)) continue;
                return (String)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public PDFPropertiesResult getPDFProperties(Document pdf, PDFPropertiesOptionSpec options) throws PDFUtilityException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("inPDFDoc", pdf);
        input.put("options", options);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "getPDFProperties", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof PDFPropertiesResult)) continue;
                return (PDFPropertiesResult)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof DSCInvocationException) {
                Throwable cause = e.getCause();
                if (cause instanceof PDFUtilityException) {
                    throw (PDFUtilityException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new DSCRuntimeException(cause);
            }
            if (e instanceof PDFUtilityException) {
                throw (PDFUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document convertXDPtoPDF(Document xdp) throws PDFUtilityException {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inDoc", xdp);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "convertXDPtoPDF", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof DSCInvocationException) {
                Throwable cause = e.getCause();
                if (cause instanceof PDFUtilityException) {
                    throw (PDFUtilityException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new DSCRuntimeException(cause);
            }
            if (e instanceof PDFUtilityException) {
                throw (PDFUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document convertPDFtoXDP(Document pdf) throws PDFUtilityException {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inDoc", pdf);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "convertPDFtoXDP", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof DSCInvocationException) {
                Throwable cause = e.getCause();
                if (cause instanceof PDFUtilityException) {
                    throw (PDFUtilityException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new DSCRuntimeException(cause);
            }
            if (e instanceof PDFUtilityException) {
                throw (PDFUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document clone(Document pdf) throws PDFUtilityException {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inPDFDoc", pdf);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "clone", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof DSCInvocationException) {
                Throwable cause = e.getCause();
                if (cause instanceof PDFUtilityException) {
                    throw (PDFUtilityException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new DSCRuntimeException(cause);
            }
            if (e instanceof PDFUtilityException) {
                throw (PDFUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public List multiclone(Document pdf, int copies) throws PDFUtilityException {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("inPDFDoc", pdf);
        input.put("copies", new Integer(copies));
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "multiclone", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof DSCInvocationException) {
                Throwable cause = e.getCause();
                if (cause instanceof PDFUtilityException) {
                    throw (PDFUtilityException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new DSCRuntimeException(cause);
            }
            if (e instanceof PDFUtilityException) {
                throw (PDFUtilityException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public PDFUtilitySaveMode getSaveMode(Document pdf) {
        HashMap<String, Document> input = new HashMap<String, Document>();
        input.put("inPDFDoc", pdf);
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "getSaveMode", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof PDFUtilitySaveMode)) continue;
                return (PDFUtilitySaveMode)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }

    public Document setSaveMode(Document pdf, PDFUtilitySaveMode saveMode, boolean override) {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("inPDFDoc", pdf);
        input.put("saveMode", saveMode);
        input.put("override", new Boolean(override));
        InvocationRequest request = this.serviceClientFactory.createInvocationRequest("PDFUtilityService", "setSaveMode", input, true);
        request.setServiceOriginalVersion("1.0");
        InvocationResponse response = null;
        try {
            response = this.serviceClientFactory.getServiceClient().invoke(request);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Document)) continue;
                return (Document)returnValue[i];
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new DSCRuntimeException((Throwable)e);
        }
    }
}

