/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.framework.JarInputSupport;
import com.adobe.logging.AdobeLogger;
import com.adobe.service.ConnectionFactory;
import com.adobe.service.ConnectionFactoryRemote;
import com.adobe.util.ConnectionFactoryReflectionWrapper;
import com.adobe.util.UtilMsg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class Utilities {
    public static final String SESSION_USER_ID = "com.adobe.session.UserID";
    private static final String configJarPath = "com/adobe/config-files.jar";
    private static final String[] SERVICE_PREFIXES = new String[]{"", "com.adobe~", "com.adobe."};
    private static final String operatingSystem = System.getProperty("os.name").toLowerCase();
    private static String appendVersion = "";
    private static AdobeLogger logger = AdobeLogger.getAdobeLogger(Utilities.class);
    public static final String PORT_JBOSS_HTTP = "8080";
    public static final String PORT_JBOSS_AJP = "8009";
    public static final String PORT_JBOSS_SSL = "8443";
    public static final String PORT_JBOSS_WEB_SERVICE = "8083";
    public static final String PORT_JBOSS_NAMING_SERVICE = "1099";
    public static final String PORT_JBOSS_RMIPORT = "1098";
    public static final String PORT_JBOSS_RMI_OBJECT_PORT = "4444";
    public static final String PORT_JBOSS_POOLED_INVOKER = "4445";
    public static final String PORT_JBOSS_HA_NAMING_SERVICE = "1100";
    public static final String PORT_JBOSS_NAMING_PROVIDER_URL = "1100";
    public static final String PORT_JBOSS_OA_PORT = "3528";
    public static final String PORT_JBOSS_OA_SSL_PORT = "3529";
    public static final String PORT_JBOSS_SNMP_AGENT_SERVICE_MGR = "1162";
    public static final String PORT_JBOSS_SNMP_MANAGER = "1162";
    public static final String PORT_JBOSS_CLUSTER_RMIPORT = "1101";
    public static final String PORT_JBOSS_CLUSTER_RMI_OBJECT_PORT = "4447";
    public static final String PORT_JBOSS_SNMP_AGENT_SERVICE = "1161";
    public static final String PORT_JBOSS_UTIL2_SERVER_BIND_PORT = "8093";
    public static final String PORT_JBOSS_HA_SERVER_BIND_PORT = "4446";
    public static final String PORT_WL_LISTEN_PORT = "7001";
    public static final String LC_JBOSS_HTTP = "LC_JBOSS_HTTP";
    public static final String LC_JBOSS_AJP = "LC_JBOSS_AJP";
    public static final String LC_JBOSS_SSL = "LC_JBOSS_SSL";
    public static final String LC_JBOSS_WEB_SERVICE = "LC_JBOSS_WEB_SERVICE";
    public static final String LC_JBOSS_NAMING_SERVICE = "LC_JBOSS_NAMING_SERVICE";
    public static final String LC_JBOSS_RMIPORT = "LC_JBOSS_RMIPORT";
    public static final String LC_JBOSS_RMI_OBJECT_PORT = "LC_JBOSS_RMI_OBJECT_PORT";
    public static final String LC_JBOSS_POOLED_INVOKER = "LC_JBOSS_POOLED_INVOKER";
    public static final String LC_JBOSS_HA_NAMING_SERVICE = "LC_JBOSS_HA_NAMING_SERVICE";
    public static final String LC_JBOSS_NAMING_PROVIDER_URL = "LC_JBOSS_NAMING_PROVIDER_URL";
    public static final String LC_JBOSS_OA_PORT = "LC_JBOSS_OA_PORT";
    public static final String LC_JBOSS_OA_SSL_PORT = "LC_JBOSS_OA_SSL_PORT";
    public static final String LC_JBOSS_SNMP_AGENT_SERVICE_MGR = "LC_JBOSS_SNMP_AGENT_SERVICE_MGR";
    public static final String LC_JBOSS_SNMP_MANAGER = "LC_JBOSS_SNMP_MANAGER";
    public static final String LC_JBOSS_CLUSTER_RMIPORT = "LC_JBOSS_CLUSTER_RMIPORT";
    public static final String LC_JBOSS_CLUSTER_RMI_OBJECT_PORT = "LC_JBOSS_CLUSTER_RMI_OBJECT_PORT";
    public static final String LC_JBOSS_SNMP_AGENT_SERVICE = "LC_JBOSS_SNMP_AGENT_SERVICE";
    public static final String LC_JBOSS_UTIL2_SERVER_BIND_PORT = "LC_JBOSS_UTIL2_SERVER_BIND_PORT";
    public static final String LC_JBOSS_HA_SERVER_BIND_PORT = "LC_JBOSS_HA_SERVER_BIND_PORT";
    public static final String LC_WL_LISTEN_PORT = "LC_WL_LISTEN_PORT";
    static final Properties DEFAULT_PORTS = new Properties();

    private Utilities() {
    }

    public static ClassLoader getClassLoader() {
        Thread myThread = Thread.currentThread();
        ClassLoader myLoader = myThread.getContextClassLoader();
        return myLoader;
    }

    public static InputStream getResourceStream(String inFileName) {
        return Utilities.getClassLoader().getResourceAsStream(inFileName);
    }

    public static String buildDomainFilter(String inPrimaryDomain) {
        return inPrimaryDomain + ".*:";
    }

    public static String buildServiceFilter(String inPrimaryDomain) {
        return inPrimaryDomain + ".*:*";
    }

    public static String escapeXML(String inString) {
        StringBuffer buff = new StringBuffer();
        char[] block = inString.toCharArray();
        String currChar = null;
        for (int i = 0; i < block.length; ++i) {
            switch (block[i]) {
                case '<': {
                    currChar = "&lt;";
                    break;
                }
                case '>': {
                    currChar = "&gt;";
                    break;
                }
                case '&': {
                    currChar = "&amp;";
                    break;
                }
                case '\"': {
                    currChar = "&quot;";
                    break;
                }
                default: {
                    currChar = String.valueOf(block[i]);
                }
            }
            buff.append(currChar);
        }
        return buff.toString();
    }

    public static boolean deleteRecursive(File target) {
        String[] cmd;
        try {
            String targetPath = target.getCanonicalPath();
            cmd = operatingSystem.indexOf("windows") > -1 ? (!target.isDirectory() ? new String[]{"cmd.exe", "/c", "del", "/s", "/f", "/q", targetPath} : new String[]{"cmd.exe", "/c", "rmdir", "/s", "/q", targetPath}) : new String[]{"rm", "-r", "-f", targetPath};
        }
        catch (IOException ex) {
            return false;
        }
        int retVal = Utilities.runCmd(cmd);
        return retVal == 0;
    }

    private static int runCmd(String[] cmd) {
        int retVal;
        Process proc;
        try {
            proc = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return -1;
        }
        try {
            proc.getOutputStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String cmdLine = Utilities.unsplit(cmd);
        StreamGobbler errorGobbler = new StreamGobbler("error stream consumer for cmd: " + cmdLine, proc.getErrorStream(), System.err);
        errorGobbler.start();
        StreamGobbler outputGobbler = new StreamGobbler("output stream consumer for cmd: " + cmdLine, proc.getInputStream(), null);
        outputGobbler.start();
        while (true) {
            try {
                retVal = proc.waitFor();
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        errorGobbler.collectThread();
        outputGobbler.collectThread();
        return retVal;
    }

    private static String unsplit(String[] strs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            buf.append(strs[i]);
        }
        return buf.toString();
    }

    public static Properties getEnvironment() {
        Properties env = new Properties();
        try {
            Map<String, String> variables = System.getenv();
            Set<String> variableNames = variables.keySet();
            Iterator<String> nameIterator = variableNames.iterator();
            for (int index = 0; index < variableNames.size(); ++index) {
                String name = nameIterator.next();
                String value = variables.get(name);
                env.setProperty(name, value);
            }
        }
        catch (Throwable ex) {
            env = new Properties();
        }
        return env;
    }

    public static String[] createNameValueList(Properties inEnv) {
        String[] envList = new String[inEnv.size()];
        int index = 0;
        try {
            if (inEnv != null) {
                Enumeration<?> names = inEnv.propertyNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    String value = inEnv.getProperty(name);
                    envList[index] = name + "=" + value;
                    ++index;
                }
            }
        }
        catch (Throwable ex) {
            envList = new String[]{};
        }
        return envList;
    }

    public static Class getTypeClass(String inType) throws ClassNotFoundException {
        Class myClass = null;
        String[] primitives = new String[]{"boolean", "byte", "char", "int", "short", "float", "double", "long"};
        Class[] primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Integer.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Long.TYPE};
        for (int i = 0; i < primitives.length; ++i) {
            if (!inType.equals(primitives[i])) continue;
            myClass = primitiveTypes[i];
        }
        if (myClass == null) {
            myClass = Utilities.getClassLoader().loadClass(inType);
        }
        return myClass;
    }

    public static ConnectionFactory serviceLookup(String inConnFactoryName) throws NameNotFoundException {
        ConnectionFactory svcConnection = null;
        for (int i = 0; i < SERVICE_PREFIXES.length; ++i) {
            Object obj = null;
            String serviceName = SERVICE_PREFIXES[i] + inConnFactoryName;
            try {
                InitialContext namingContext = new InitialContext();
                obj = namingContext.lookup(serviceName);
                svcConnection = obj instanceof ConnectionFactory ? (ConnectionFactory)obj : (ConnectionFactory)PortableRemoteObject.narrow((Object)obj, ConnectionFactoryRemote.class);
            }
            catch (NamingException exp) {
            }
            catch (ClassCastException e) {
                if (obj.getClass().getName().startsWith(ConnectionFactory.class.getName())) {
                    svcConnection = new ConnectionFactoryReflectionWrapper(obj);
                }
                throw new ClassCastException("The object resolved in JNDI under the name \"" + serviceName + "\" is not a " + ConnectionFactory.class.getName() + ". It is a " + obj.getClass().getName());
            }
            if (svcConnection != null) break;
        }
        if (svcConnection == null) {
            throw new NameNotFoundException();
        }
        return svcConnection;
    }

    public static String replaceAll(String inOriginal, String inSubString, String inReplacement) {
        int last = 0;
        int pos = 0;
        StringBuffer stringValue = new StringBuffer(inOriginal);
        while ((pos = stringValue.toString().indexOf(inSubString, last)) >= 0) {
            last = pos;
            stringValue.replace(pos, pos + inSubString.length(), inReplacement);
        }
        return stringValue.toString();
    }

    public static void copyConfigResources(File dest) throws IOException {
        Utilities.unpackResources(configJarPath, dest);
    }

    public static void unpackResources(String src, File dest) throws IOException {
        Utilities.unpackResources(src, dest, false);
    }

    public static void unpackResources(String src, File dest, boolean setSharedXbit) throws IOException {
        JarInputSupport inputJar = new JarInputSupport(Utilities.getResourceStream(src), false);
        if (inputJar == null) {
            return;
        }
        inputJar.extractAll(dest.getCanonicalPath(), true, setSharedXbit);
        inputJar.close();
    }

    public static String encodeString(String inString) {
        try {
            byte[] inBytes = inString.getBytes();
            return new BASE64Encoder().encode(inBytes);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String decodeString(String inString) {
        try {
            byte[] inBytes = new BASE64Decoder().decodeBuffer(inString);
            return new String(inBytes);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String nomalizeFilePath(String inFileName, String inOldSeparator, String inPathSeparator) {
        int i = 0;
        StringBuffer result = new StringBuffer(inFileName);
        while ((i = inFileName.indexOf(inOldSeparator, i)) != -1) {
            result.replace(i, i + 1, inPathSeparator);
            ++i;
        }
        return result.toString();
    }

    public static String[] tokenizeString(String inStr) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(inStr));
        st.resetSyntax();
        st.whitespaceChars(1, 32);
        st.wordChars(33, 126);
        st.quoteChar(34);
        st.quoteChar(39);
        ArrayList<String> al = new ArrayList<String>();
        try {
            while (st.nextToken() != -1) {
                al.add(st.sval);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] resStrArray = al.toArray(new String[al.size()]);
        return resStrArray;
    }

    public static void setFileMode(String filePath, boolean writeAccess, boolean execAccess) {
        String chmodcommand = null;
        if (!writeAccess && !execAccess) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Win")) {
            chmodcommand = "CMD.exe /Q /D /C ATTRIB ";
            if (writeAccess) {
                chmodcommand = chmodcommand + "-R";
            }
        } else {
            chmodcommand = "chmod a";
            if (writeAccess) {
                chmodcommand = chmodcommand + "+w";
            }
            if (execAccess) {
                chmodcommand = chmodcommand + "+x";
            }
        }
        chmodcommand = chmodcommand + " " + filePath;
        try {
            Process p = Runtime.getRuntime().exec(chmodcommand);
            try {
                p.waitFor();
            }
            catch (InterruptedException ie) {}
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e, "Error setting file mode");
        }
    }

    public static String getVersionSuffix() {
        if (appendVersion == "") {
            Properties serviceProps = new Properties();
            try {
                ResourceBundle labels = ResourceBundle.getBundle("com.adobe.serviceProp");
                Enumeration<String> names = labels.getKeys();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    serviceProps.put(name, labels.getObject(name));
                }
                String serviceVersion = serviceProps.getProperty("version");
                if (serviceVersion != null) {
                    appendVersion = serviceVersion;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return appendVersion;
    }

    public static String getServerPort(String portName) {
        String port = null;
        port = System.getProperty(portName);
        if (null == port) {
            port = DEFAULT_PORTS.getProperty(portName);
        }
        return port;
    }

    static {
        DEFAULT_PORTS.setProperty(LC_JBOSS_HTTP, PORT_JBOSS_HTTP);
        DEFAULT_PORTS.setProperty(LC_JBOSS_AJP, PORT_JBOSS_AJP);
        DEFAULT_PORTS.setProperty(LC_JBOSS_SSL, PORT_JBOSS_SSL);
        DEFAULT_PORTS.setProperty(LC_JBOSS_WEB_SERVICE, PORT_JBOSS_WEB_SERVICE);
        DEFAULT_PORTS.setProperty(LC_JBOSS_NAMING_SERVICE, PORT_JBOSS_NAMING_SERVICE);
        DEFAULT_PORTS.setProperty(LC_JBOSS_RMIPORT, PORT_JBOSS_RMIPORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_RMI_OBJECT_PORT, PORT_JBOSS_RMI_OBJECT_PORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_POOLED_INVOKER, PORT_JBOSS_POOLED_INVOKER);
        DEFAULT_PORTS.setProperty(LC_JBOSS_HA_NAMING_SERVICE, "1100");
        DEFAULT_PORTS.setProperty(LC_JBOSS_NAMING_PROVIDER_URL, "1100");
        DEFAULT_PORTS.setProperty(LC_JBOSS_OA_PORT, PORT_JBOSS_OA_PORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_OA_SSL_PORT, PORT_JBOSS_OA_SSL_PORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_SNMP_AGENT_SERVICE_MGR, "1162");
        DEFAULT_PORTS.setProperty(LC_JBOSS_SNMP_MANAGER, "1162");
        DEFAULT_PORTS.setProperty(LC_JBOSS_CLUSTER_RMIPORT, PORT_JBOSS_CLUSTER_RMIPORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_CLUSTER_RMI_OBJECT_PORT, PORT_JBOSS_CLUSTER_RMI_OBJECT_PORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_SNMP_AGENT_SERVICE, PORT_JBOSS_SNMP_AGENT_SERVICE);
        DEFAULT_PORTS.setProperty(LC_JBOSS_UTIL2_SERVER_BIND_PORT, PORT_JBOSS_UTIL2_SERVER_BIND_PORT);
        DEFAULT_PORTS.setProperty(LC_JBOSS_HA_SERVER_BIND_PORT, PORT_JBOSS_HA_SERVER_BIND_PORT);
        DEFAULT_PORTS.setProperty(LC_WL_LISTEN_PORT, PORT_WL_LISTEN_PORT);
    }

    private static class EnvironmentStream
    extends InputStream {
        private boolean pushedBack = false;
        private PushbackInputStream mStream = null;

        public EnvironmentStream(InputStream inStream) {
            this.mStream = new PushbackInputStream(inStream);
        }

        public final int read() throws IOException {
            int data = this.mStream.read();
            if (data == 92) {
                if (!this.pushedBack) {
                    this.pushedBack = true;
                    this.mStream.unread(data);
                } else {
                    this.pushedBack = false;
                }
            }
            return data;
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final int BUFLEN = 512;
        private byte[] buffer = new byte[512];
        final InputStream is;
        final OutputStream copyTo;

        StreamGobbler(String name, InputStream is, OutputStream copyTo) {
            super(name);
            this.setDaemon(true);
            this.is = is;
            this.copyTo = copyTo;
        }

        public void run() {
            try {
                int bytesRead;
                while (!StreamGobbler.interrupted() && (bytesRead = this.is.read(this.buffer)) != -1) {
                    if (this.copyTo == null) continue;
                    this.copyTo.write(this.buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void collectThread() {
            this.interrupt();
            try {
                this.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isAlive()) {
                logger.log(UtilMsg.THREAD_APPARENTLY_HUNG, (Object)this);
                this.interrupt();
            }
        }
    }
}

