/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class PropertiesInvocationHandler
implements InvocationHandler {
    Properties props = null;
    Object defaults = null;
    File directory = null;
    boolean fallbackToSystemProperties = false;
    private static final Object[] emptyArgs = new Object[0];

    public PropertiesInvocationHandler(String idIn, File in, Object def) throws FileNotFoundException, IOException {
        this.props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(in);
            this.props.loadFromXML(fis);
        }
        catch (InvalidPropertiesFormatException ie) {
            IOException ioe = new IOException();
            ioe.initCause(ie);
            throw ioe;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        this.props.setProperty("id", idIn);
        this.directory = in.getParentFile();
        this.defaults = def;
    }

    public PropertiesInvocationHandler(Properties in, Object def) {
        this.props = in;
        this.defaults = def;
    }

    public Object getProperty(String target, Method m) {
        Object out = this.props.getProperty(target);
        if (out == null) {
            if (this.fallbackToSystemProperties) {
                out = this.trySystemProperty(m, target);
            }
            if (out == null && this.defaults != null) {
                try {
                    out = m.invoke(this.defaults, emptyArgs);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
        return out;
    }

    private Object trySystemProperty(Method m, String target) {
        StringBuffer name = new StringBuffer(m.getDeclaringClass().getCanonicalName());
        name.append('.');
        name.append(target);
        return System.getProperty(name.toString());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.props.toString();
        }
        if (method.getName().equals("getDirectory")) {
            return this.directory;
        }
        if (method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (method.getName().equals("equals")) {
            return method.invoke((Object)this, args);
        }
        String target = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        Class<?> returnType = method.getReturnType();
        Object out = null;
        if (returnType == String.class) {
            out = (String)this.getProperty(target, method);
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            out = this.getProperty(target, method);
            if (out instanceof String) {
                try {
                    out = Long.parseLong((String)out);
                }
                catch (NumberFormatException nfe) {
                    out = null;
                }
            }
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            out = this.getProperty(target, method);
            if (out instanceof String) {
                try {
                    out = Integer.parseInt((String)out);
                }
                catch (NumberFormatException nfe) {
                    out = null;
                }
            }
        } else if (returnType == Boolean.class || returnType == Boolean.TYPE) {
            out = this.getProperty(target, method);
            if (out instanceof String) {
                out = Boolean.parseBoolean((String)out);
            }
        } else {
            out = "unsupported data type: " + returnType;
        }
        return out;
    }

    public boolean isFallbackToSystemProperties() {
        return this.fallbackToSystemProperties;
    }

    public void setFallbackToSystemProperties(boolean fallbackToSystemProperties) {
        this.fallbackToSystemProperties = fallbackToSystemProperties;
    }
}

