/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.PropertiesInvocationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public abstract class PropertiesConfig {
    Object newConfigFromResourcePath(ClassLoader cl, Class intf) throws IOException {
        String[] paths = this.getPaths();
        String finalPath = null;
        URL url = null;
        for (int i = 0; url == null && i < paths.length; ++i) {
            url = cl.getResource(paths[i]);
            finalPath = paths[i];
        }
        if (url == null) {
            PropertiesInvocationHandler h = new PropertiesInvocationHandler(new Properties(), this.getDefaultsObject());
            h.setFallbackToSystemProperties(true);
            return Proxy.newProxyInstance(cl, new Class[]{intf}, (InvocationHandler)h);
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = cl.getResourceAsStream(finalPath);
            props.loadFromXML(is);
        }
        catch (InvalidPropertiesFormatException ie) {
            IOException ioe = new IOException();
            ioe.initCause(ie);
            throw ioe;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        PropertiesInvocationHandler h = new PropertiesInvocationHandler(props, this.getDefaultsObject());
        h.setFallbackToSystemProperties(true);
        return Proxy.newProxyInstance(cl, new Class[]{intf}, (InvocationHandler)h);
    }

    public Object newConfigFromResourcePath() throws IOException {
        return this.newConfigFromResourcePath(this.getClassLoader(), this.getInterface());
    }

    public abstract String[] getPaths();

    public ClassLoader getClassLoader() {
        return this.getClientClass().getClassLoader();
    }

    public Class getClientClass() {
        return this.getClass();
    }

    public abstract Class getInterface();

    public Object getDefaultsObject() {
        if (this.getInterface().isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

