/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.RandomAccessFileBox;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathToRandomAccessFileMap
extends LinkedHashMap<String, ArrayList<RandomAccessFileBox>> {
    private static final long serialVersionUID = -2776402068804942715L;
    public static final int MAX_OPEN_RANDOM_ACCESS_FILES = 64;
    static final ArrayList<PathToRandomAccessFileMap> maps = new ArrayList();
    int localSize = 0;

    void writeObject(ObjectOutputStream oos) {
        throw new RuntimeException("Serialization Not Supported.");
    }

    void readObject(ObjectOutputStream oos) {
        throw new RuntimeException("Serialization Not Supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathToRandomAccessFileMap() {
        super(10, 0.75f, true);
        ArrayList<PathToRandomAccessFileMap> arrayList = maps;
        synchronized (arrayList) {
            maps.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll(String path) {
        ArrayList<PathToRandomAccessFileMap> arrayList = maps;
        synchronized (arrayList) {
            Iterator<PathToRandomAccessFileMap> i = maps.iterator();
            while (i.hasNext()) {
                PathToRandomAccessFileMap map;
                PathToRandomAccessFileMap pathToRandomAccessFileMap = map = i.next();
                synchronized (pathToRandomAccessFileMap) {
                    ArrayList al = (ArrayList)map.get(path);
                    if (al != null) {
                        Iterator ri = al.iterator();
                        while (ri.hasNext()) {
                            RandomAccessFileBox box = (RandomAccessFileBox)ri.next();
                            if (box != null) {
                                box.close();
                                --map.localSize;
                            }
                            ri.remove();
                        }
                    }
                    map.remove(path);
                }
            }
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, ArrayList<RandomAccessFileBox>> eldest) {
        if (this.localSize <= 64) {
            return false;
        }
        ArrayList<RandomAccessFileBox> al = null;
        String eldestKey = null;
        while (eldest != null) {
            al = eldest.getValue();
            eldestKey = eldest.getKey();
            if (al == null || al.size() == 0) {
                this.remove(eldest.getKey());
                eldest = this.entrySet().iterator().next();
                continue;
            }
            eldest = null;
        }
        Iterator i = al.iterator();
        while (i.hasNext()) {
            RandomAccessFileBox box = (RandomAccessFileBox)i.next();
            if (box == null) continue;
            box.close();
            --this.localSize;
            i.remove();
            if (al.size() < 1) {
                this.remove(eldestKey);
            }
            return false;
        }
        return false;
    }

    public synchronized void putRandomAccessFile(String path, RandomAccessFile raf) {
        ++this.localSize;
        ArrayList<RandomAccessFileBox> al = (ArrayList<RandomAccessFileBox>)this.get(path);
        if (al == null) {
            al = new ArrayList<RandomAccessFileBox>();
            al.add(new RandomAccessFileBox(raf));
            this.put(path, al);
        } else {
            al.add(new RandomAccessFileBox(raf));
        }
        this.removeEldestEntry(this.entrySet().iterator().next());
    }

    public synchronized void putRandomAccessFileBox(String path, RandomAccessFileBox box) {
        ++this.localSize;
        ArrayList<RandomAccessFileBox> al = (ArrayList<RandomAccessFileBox>)this.get(path);
        if (al == null) {
            al = new ArrayList<RandomAccessFileBox>();
            al.add(box);
            this.put(path, al);
        } else {
            al.add(box);
        }
        this.removeEldestEntry(this.entrySet().iterator().next());
    }

    public synchronized RandomAccessFile getRandomAccessFile(String path) {
        ArrayList al = (ArrayList)this.get(path);
        if (al == null) {
            return null;
        }
        if (al.size() < 1) {
            return null;
        }
        --this.localSize;
        RandomAccessFileBox box = (RandomAccessFileBox)al.remove(0);
        RandomAccessFile raf = box.raf;
        if (al.size() == 0) {
            this.remove(path);
        }
        return raf;
    }

    public synchronized RandomAccessFileBox getRandomAccessFileBox(String path) {
        ArrayList al = (ArrayList)this.get(path);
        if (al == null) {
            return null;
        }
        if (al.size() < 1) {
            return null;
        }
        --this.localSize;
        RandomAccessFileBox box = (RandomAccessFileBox)al.remove(0);
        if (al.size() == 0) {
            this.remove(path);
        }
        return box;
    }
}

