/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.logging.AdobeLogger;
import com.adobe.util.BackupUtil;
import com.adobe.util.CoreConfigUtil;
import com.adobe.util.FileUtil;
import com.adobe.util.PathToRandomAccessFileMap;
import com.adobe.util.Platform;
import com.adobe.util.UtilMsg;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCollector
extends Thread {
    private static AdobeLogger logger = AdobeLogger.getAdobeLogger(FileCollector.class);
    private static long _sleepTime = -1L;
    private long staleInLastWeek = 0L;
    private long staleInLast24Hours = 0L;
    private long staleInLastHour = 0L;
    private int totalStaleFiles = 0;
    private long cTime = 0L;
    private static long lastInfoReportTime = 0L;
    private Random random = new Random();
    private ArrayList<File> sampleStaleFiles = new ArrayList();
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static int DELETION_REPORT_INTERVAL_WARNING = 0x6DDD00;
    private static int DELETION_REPORT_INTERVAL_INFO = 1800000;
    static Hashtable<File, Long> _rootEntries = new Hashtable();
    static Hashtable<File, ChangeSequenceCounter> _changeCounters = new Hashtable();
    private static int debugManagedFiles = -1;
    static final String DEBUG_MANAGED_FILES = "debugManagedFiles";
    private static final String ADOBE_PREFIX = "com.adobe.idp.";
    private static HashSet debugChanges = null;
    static Object _collectorThread = null;
    private static boolean _enabled = false;
    private HashMap<File, Integer> _staleFiles = new HashMap();
    private long staleSizeInLastWeek;
    private long staleSizeInLast24Hours;
    private long staleSizeInLastHour;
    private long totalStaleSize;
    private long lastWarningReportTime;
    private static final File NO_MARKER = new File("");
    private static int markTimeCount = 0;
    private static Object markTimeLock = new Object();
    private static final String filler = "000000";
    public static final int SHORT_EXPIRATION_MARKER_SIZE = 32;
    private static final String INVOCATION_SESSION_PREFIX = "Invocation-";
    private static long _invocationId = 0L;
    private static Object _invocationIdMutex = new Object();
    private static String _runId = UUID.randomUUID().toString().replace("-", "");

    public static long getSleepTime() {
        if (_sleepTime < 0L) {
            _sleepTime = CoreConfigUtil.getConfigParamAsInt("globalDocumentStorageSweepInterval", 30) * 1000;
        }
        logger.fine("The document storage sweep interval is: " + Long.toString(_sleepTime));
        return _sleepTime;
    }

    public static void setSleepTime(long sleepTime) {
        _sleepTime = sleepTime;
    }

    static boolean getDebugManagedFiles() {
        if (debugManagedFiles < 0) {
            String val = System.getProperty("com.adobe.idp.debugManagedFiles");
            if (val != null) {
                logger.debug("The \"debugManagedFiles\" parameter was set in a systemt property. The value is \"" + val + "\"");
                if (val.indexOf(58) != -1) {
                    String[] changes = val.split(":");
                    debugChanges = new HashSet();
                    for (int i = 0; changes != null && i < changes.length; ++i) {
                        String change = changes[i].trim();
                        debugChanges.add(change);
                    }
                    debugManagedFiles = 1;
                } else {
                    debugManagedFiles = new Boolean(val) != false ? 1 : 0;
                }
            } else {
                debugManagedFiles = CoreConfigUtil.getConfigParamAsBoolean(DEBUG_MANAGED_FILES, false) ? 1 : 0;
            }
        }
        return debugManagedFiles > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugReportFileChange(File file, String change) {
        if (!FileCollector.getDebugManagedFiles()) {
            return;
        }
        if (file == null || change == null) {
            return;
        }
        if (debugChanges != null && !debugChanges.contains(change)) {
            return;
        }
        try {
            PrintWriter pw = null;
            try {
                pw = FileCollector.newDebugFile(file, change);
                if (pw == null) {
                    return;
                }
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i = 3; i < stack.length; ++i) {
                    pw.println(stack[i]);
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OutputStream newDebugOutputStream(File file, String change) {
        Object rootPath;
        FileOutputStream fos = null;
        File root = null;
        String pathTail = null;
        Iterator<File> roots = _rootEntries.keySet().iterator();
        while (roots.hasNext()) {
            try {
                File rootDir = roots.next();
                rootPath = rootDir.getCanonicalPath();
                String filePath = file.getCanonicalPath();
                rootPath = ((String)rootPath).replace('\\', '/');
                filePath = filePath.replace('\\', '/');
                if (!((String)rootPath).endsWith("/")) {
                    rootPath = (String)rootPath + "/";
                }
                if (!filePath.startsWith((String)rootPath)) continue;
                root = rootDir;
                pathTail = filePath.substring(((String)rootPath).length());
                pathTail = pathTail.replace('/', '#');
                break;
            }
            catch (Throwable e) {
                logger.log(e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"mapping a file to its root.");
                if (!(e instanceof Error)) continue;
                throw (Error)e;
            }
        }
        if (root == null) {
            return null;
        }
        ChangeSequenceCounter counter = null;
        rootPath = _changeCounters;
        synchronized (rootPath) {
            counter = _changeCounters.get(root);
            if (counter == null) {
                counter = new ChangeSequenceCounter();
                _changeCounters.put(root, counter);
            }
        }
        File debugRoot = new File(root, "debug");
        debugRoot.mkdirs();
        int count = -1;
        File highDir = null;
        ChangeSequenceCounter changeSequenceCounter = counter;
        synchronized (changeSequenceCounter) {
            count = counter.count++;
            String highDirName = Platform.UTIL.getServerInstanceId() + "-" + (count / 1000 + 10000000);
            highDir = new File(debugRoot, highDirName);
            if (!highDir.mkdirs() && !highDir.exists()) {
                System.out.println("Couldn't make file change report directory " + highDir.getPath());
                return null;
            }
        }
        File debugFile = new File(highDir, (long)count + 10000000000L + "-" + pathTail + "-" + change + "-" + System.currentTimeMillis() + "-" + Platform.UTIL.getServerInstanceId());
        try {
            fos = new FileOutputStream(debugFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return fos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrintWriter newDebugFile(File file, String change) {
        PrintWriter pw = null;
        OutputStream os = null;
        try {
            os = FileCollector.newDebugOutputStream(file, change);
            if (os != null) {
                pw = new PrintWriter(os);
            }
        }
        finally {
            if (pw == null && os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
        return pw;
    }

    public static synchronized void addRootDir(File rootDir, long timeSkewDelta) {
        if (!_rootEntries.containsKey(rootDir)) {
            _rootEntries.put(rootDir, timeSkewDelta);
        }
    }

    public static FileCollector getFileCollector() {
        return (FileCollector)_collectorThread;
    }

    public static void enable() {
        _enabled = true;
    }

    public static synchronized void checkCollectorThread() {
        if (_enabled && FileCollector.getSleepTime() != 0L && _collectorThread == null) {
            _collectorThread = new FileCollector();
        }
    }

    public FileCollector() {
        this.setDaemon(true);
        this.setName("Adobe LiveCycle File Collector Thread");
        this.start();
    }

    @Override
    public String toString() {
        return "DocumentContentCollector thread (" + System.identityHashCode(this) + ")";
    }

    public boolean collectFiles(File rootDir, long currentTime, Hashtable<String, File> removedSessions) {
        int i;
        boolean isBackedUp = BackupUtil.isBackupRoot(rootDir);
        if (isBackedUp) {
            try {
                Iterator i2 = BackupUtil.listDeletionQueue();
                while (i2.hasNext()) {
                    File file = (File)i2.next();
                    String name = file.getName();
                    if (name.startsWith("session") && name.endsWith(".remove")) {
                        String sessionPathName = BackupUtil.decodePath(name).getName();
                        String session = sessionPathName.substring("session".length(), sessionPathName.length() - ".remove".length());
                        removedSessions.put(session, file);
                        continue;
                    }
                    if (name.startsWith("dQ") || name.startsWith("!!dQ")) {
                        FileCollector.internalDelete(file);
                        continue;
                    }
                    File d = BackupUtil.decodePath(name);
                    if (!FileCollector.internalDelete(d)) continue;
                    FileCollector.internalDelete(file);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        File[] children = FileCollector.listFiles(rootDir);
        if (FileCollector.getDebugManagedFiles() && (debugChanges == null || debugChanges.contains("time"))) {
            this.markTime(rootDir);
        }
        if (children == null) {
            return false;
        }
        for (i = 0; i < children.length; ++i) {
            File file = children[i];
            String name = file.getName();
            if (file.isFile() && name.startsWith("session") && (name.endsWith(".remove") || name.endsWith(".del"))) {
                int suffixLength = ".del".length();
                if (name.endsWith(".remove")) {
                    suffixLength = ".remove".length();
                }
                String session = name.substring("session".length(), name.length() - suffixLength);
                boolean staged = false;
                if (isBackedUp && !FileCollector.isInvocationSession(session)) {
                    try {
                        name = FileUtil.sessionToDirName(session) + ".remove";
                        BackupUtil.queueDeletion(name);
                        FileCollector.internalDelete(file);
                    }
                    catch (IOException e) {}
                    continue;
                }
                removedSessions.put(session, file);
                continue;
            }
            if (!file.isDirectory() || !this.isManagedDir(file)) continue;
            subDirs.add(file);
        }
        if (subDirs.size() == 0) {
            return false;
        }
        logger.finer("Going through " + subDirs.size() + " directories under: \"" + rootDir + "\"");
        for (i = 0; i < subDirs.size(); ++i) {
            String name;
            File file2;
            int j;
            File dir = (File)subDirs.get(i);
            File[] files = FileCollector.listFiles(dir);
            if (files == null) continue;
            HashMap<String, File> file2expir = new HashMap<String, File>();
            HashMap<String, File> file2session = new HashMap<String, File>();
            for (j = 0; j < files.length; ++j) {
                String content;
                File oldMarkerFile;
                file2 = files[j];
                name = file2.getName();
                if (FileCollector.isExpirationMarker(name)) {
                    files[j] = null;
                    String content2 = FileCollector.getFileFromExpirationMarker(name);
                    File oldMarkerFile2 = (File)file2expir.get(content2);
                    if (oldMarkerFile2 != null) {
                        long oldExp;
                        long newExp = FileCollector.getTimeFromExpirationMarker(name);
                        if (newExp > (oldExp = FileCollector.getTimeFromExpirationMarker(oldMarkerFile2.getName()))) {
                            file2expir.put(content2, file2);
                        } else {
                            oldMarkerFile2 = file2;
                        }
                        long expiration = FileCollector.getTimeFromExpirationMarker(oldMarkerFile2.getName());
                        if (currentTime <= expiration) continue;
                        FileCollector.internalDelete(oldMarkerFile2);
                        continue;
                    }
                    file2expir.put(content2, file2);
                    continue;
                }
                if (!FileCollector.isSessionMarker(name)) continue;
                files[j] = null;
                int x = name.lastIndexOf(INVOCATION_SESSION_PREFIX);
                if (x > 0) {
                    String uuid;
                    int y = name.lastIndexOf("-");
                    int z = name.lastIndexOf("-", y - 1);
                    String serverName = name.substring(x += INVOCATION_SESSION_PREFIX.length(), z);
                    if (Platform.UTIL.getServerInstanceId().equals(serverName) && !(uuid = name.substring(z + 1, y)).equals(_runId)) {
                        FileCollector.internalDelete(file2);
                        continue;
                    }
                }
                if ((oldMarkerFile = (File)file2session.get(content = FileCollector.getFileFromSessionMarker(name))) != null) {
                    String newSession = FileCollector.getSessionFromSessionMarker(name);
                    String oldMarker = oldMarkerFile.getName();
                    String oldSession = FileCollector.getSessionFromSessionMarker(oldMarker);
                    if (!removedSessions.containsKey(newSession)) {
                        file2session.put(content, file2);
                        if (!removedSessions.containsKey(oldSession)) continue;
                        FileCollector.internalDelete(oldMarkerFile);
                        continue;
                    }
                    FileCollector.internalDelete(file2);
                    continue;
                }
                file2session.put(content, file2);
            }
            for (j = 0; j < files.length; ++j) {
                file2 = files[j];
                if (file2 == null) continue;
                name = file2.getName();
                File file2delete = null;
                File marker2delete = null;
                File sessionMarker = (File)file2session.get(name);
                String session = sessionMarker != null ? FileCollector.getSessionFromSessionMarker(sessionMarker.getName()) : null;
                File expirMarker = (File)file2expir.get(name);
                file2expir.put(name, null);
                if (expirMarker != null) {
                    long expiration = FileCollector.getTimeFromExpirationMarker(expirMarker.getName());
                    if (currentTime > expiration) {
                        if (sessionMarker != null) {
                            FileCollector.internalDelete(expirMarker);
                            if (removedSessions.containsKey(session)) {
                                file2delete = file2;
                                marker2delete = sessionMarker;
                            }
                        } else {
                            file2delete = file2;
                            marker2delete = expirMarker;
                        }
                    } else if (sessionMarker != null && removedSessions.containsKey(session)) {
                        FileCollector.internalDelete(sessionMarker);
                    }
                } else if (sessionMarker != null && removedSessions.containsKey(session)) {
                    file2delete = file2;
                    marker2delete = sessionMarker;
                }
                if (file2delete == null) continue;
                logger.finer("Deleting file: " + file2delete);
                if (FileCollector.internalDelete(file2delete) || !file2delete.exists()) {
                    FileCollector.internalDelete(marker2delete);
                    continue;
                }
                this.addStaleFile(file2delete);
                String markerName = marker2delete.getName();
                if (!FileCollector.isSessionMarker(markerName)) continue;
                removedSessions.put(session, NO_MARKER);
            }
            for (File file2 : file2expir.values()) {
                long expiration;
                if (file2 == null || currentTime <= (expiration = FileCollector.getTimeFromExpirationMarker(file2.getName()))) continue;
                FileCollector.internalDelete(file2);
            }
        }
        return true;
    }

    public static boolean isInvocationSession(String session) {
        String[] bits = session.split("-");
        if (bits.length >= 4) {
            if (!"Invocation".equals(bits[0])) {
                return false;
            }
            return bits[bits.length - 2].matches("[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]") && bits[bits.length - 1].matches("[0-9][0-9]*");
        }
        return false;
    }

    private static boolean internalDelete(File target) {
        return FileCollector.realDelete(target);
    }

    private static boolean realDelete(File target) {
        FileCollector.debugReportFileChange(target, "delete");
        PathToRandomAccessFileMap.closeAll(target.getAbsolutePath());
        boolean deleted = target.delete();
        return deleted;
    }

    public static boolean clientDelete(File target) {
        return FileCollector.realDelete(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void markTime(File rootDir) {
        String instanceId = Platform.UTIL.getServerInstanceId();
        if (instanceId == null) {
            instanceId = "singletonServer";
        }
        int count = -1;
        String markTimeDirString = rootDir.getPath() + "/timedebug-" + instanceId;
        File markTimeDir = null;
        Object object = markTimeLock;
        synchronized (object) {
            markTimeDirString = markTimeDirString + "-" + ++markTimeCount / 500;
            markTimeDir = new File(markTimeDirString);
            if (!markTimeDir.mkdirs() && !markTimeDir.exists()) {
                System.out.println("Couldn't make time sync mark directory " + markTimeDirString);
            }
            count = markTimeCount;
        }
        long currentTime = System.currentTimeMillis();
        String markTimeString = currentTime + "," + count;
        File markTimeFile = new File(markTimeDir, markTimeString);
        try {
            if (markTimeFile.createNewFile()) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("failed to make time sync mark " + markTimeString);
    }

    private void resetStaleFileCounts() {
        this.cTime = System.currentTimeMillis();
        this.totalStaleFiles = 0;
        this.staleInLastHour = 0L;
        this.staleSizeInLastHour = 0L;
        this.staleInLast24Hours = 0L;
        this.staleSizeInLast24Hours = 0L;
        this.staleInLastWeek = 0L;
        this.staleSizeInLastWeek = 0L;
        this.totalStaleSize = 0L;
        this.sampleStaleFiles.clear();
    }

    private void addStaleFile(File file) {
        try {
            File stale = new File(file.getParent(), file.getName() + ".stale");
            long size = file.length();
            long originalDeletion = 0L;
            if (!stale.exists()) {
                try {
                    stale.createNewFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            originalDeletion = stale.lastModified();
            try {
                if (logger.isLoggable(Level.FINER)) {
                    long attempts = (this.cTime - originalDeletion) / FileCollector.getSleepTime();
                    if (attempts < 1L || originalDeletion == 0L) {
                        attempts = 1L;
                    }
                    logger.log(UtilMsg.FAILED_TO_DELETE_FILE_AFTER_N_ATTEMPTS, (Object)file.getAbsolutePath(), (Object)1);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (originalDeletion > this.cTime - 604800000L) {
                ++this.staleInLastWeek;
                this.staleSizeInLastWeek += size / 1024L;
            }
            if (originalDeletion > this.cTime - 86400000L) {
                ++this.staleInLast24Hours;
                this.staleSizeInLast24Hours += size / 1024L;
            }
            if (originalDeletion > this.cTime - 3600000L) {
                ++this.staleInLastHour;
                this.staleSizeInLastHour += size / 1024L;
            }
            ++this.totalStaleFiles;
            this.totalStaleSize += size / 1024L;
            if (this.sampleStaleFiles.size() < 20) {
                this.sampleStaleFiles.add(file);
            } else {
                int r = this.random.nextInt(200);
                if (r < 20) {
                    this.sampleStaleFiles.set(r, file);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean collectDirs(File rootDir, long currentTime, Hashtable<String, File> removedSessions) {
        File[] dirs = FileCollector.listFiles(rootDir, new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (dirs == null || dirs.length == 0) {
            return false;
        }
        logger.finer("Going through " + dirs.length + " directories under: \"" + rootDir + "\"");
        for (int i = 0; i < dirs.length; ++i) {
            long removeTime;
            String session;
            String name;
            File dir = dirs[i];
            if (!this.isManagedDir(dir) || ((name = dir.getName()).startsWith("session") ? !removedSessions.containsKey(session = name.substring("session".length())) : name.startsWith("removeOn") && ((removeTime = FileUtil.dirNameToTime(name)) == 0L || removeTime >= currentTime))) continue;
            this.deleteDir(dir, removedSessions, currentTime);
        }
        Enumeration<String> sessions = removedSessions.keys();
        while (sessions.hasMoreElements()) {
            String session = sessions.nextElement();
            File marker = removedSessions.get(session);
            if (marker == NO_MARKER) continue;
            FileCollector.internalDelete(marker);
        }
        return true;
    }

    static File[] listFiles(File rootDir) {
        File[] list = rootDir.listFiles();
        FileCollector.debugReportListFiles(rootDir, "listFiles", list);
        return list;
    }

    private static void debugReportListFiles(File rootDir, String change, File[] list) {
        if (!FileCollector.getDebugManagedFiles()) {
            return;
        }
        if (rootDir == null || change == null) {
            return;
        }
        if (debugChanges == null || !debugChanges.contains(change)) {
            return;
        }
        PrintWriter pw = FileCollector.newDebugFile(rootDir, change);
        if (pw == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            pw.println(list[i].getAbsolutePath());
        }
        pw.close();
    }

    static File[] listFiles(File rootDir, FileFilter filter) {
        File[] list = rootDir.listFiles(filter);
        FileCollector.debugReportListFiles(rootDir, "listFiles", list);
        return list;
    }

    static File[] listFiles(File r, FilenameFilter filter) {
        File[] list = r.listFiles(filter);
        FileCollector.debugReportListFiles(r, "listFiles", list);
        return list;
    }

    private boolean isManagedDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        String dirName = dir.getName();
        return dirName.startsWith("session") || dirName.startsWith("removeOn") || dirName.startsWith("datam") || dirName.startsWith("docm");
    }

    public static File getShortLifeTimeMarker(File file, int disposalTimeout) {
        String timeString = Integer.toString(disposalTimeout, 36);
        if (timeString.length() < filler.length()) {
            timeString = filler.substring(timeString.length()) + timeString;
        }
        return new File(file + "0" + timeString);
    }

    public static long expirationFromShortMarker(File marker) {
        int disposalTimeout = FileCollector.disposalTimeoutFromShortMarker(marker.getName());
        if (disposalTimeout == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        File docmDir = marker.getParentFile();
        String docmName = docmDir.getName();
        long base = Long.MAX_VALUE;
        try {
            base = Long.parseLong(docmName.substring("docm".length()));
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        if (base == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return base + (long)(disposalTimeout * 1000);
    }

    public static int disposalTimeoutFromShortMarker(String name) {
        char f = name.charAt(0);
        if (f >= 'g' || f <= 'z' && name.length() == 32) {
            char key = name.charAt(name.length() - 7);
            if (key == '0') {
                String expirationString = name.substring(name.length() - 6);
                try {
                    int disposalInt = Integer.parseInt(expirationString, 36);
                    return disposalInt;
                }
                catch (NumberFormatException nfe) {
                    return Integer.MAX_VALUE;
                }
            }
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private boolean checkFileForExclusion(File file, File dir, long currentTime, HashSet noted, HashSet<File> excluded, boolean isDataManDir) {
        String name = file.getName();
        File target = null;
        if (FileCollector.isExpirationMarker(name)) {
            target = new File(dir, FileCollector.getFileFromExpirationMarker(name));
            excluded.add(file);
            excluded.add(target);
        } else {
            if (isDataManDir && FileCollector.isDataManRemovalMarker(name)) {
                excluded.add(file);
                return true;
            }
            if (name.endsWith(".del")) {
                noted.add(file.getAbsolutePath());
            } else if (FileCollector.isShortExpirationMarker(name)) {
                noted.add(file.getAbsolutePath());
            }
        }
        return false;
    }

    private void deleteDir(File dir, Hashtable<String, File> removedSessions, long currentTime) {
        File file;
        int i;
        if (!this.isManagedDir(dir)) {
            String msg = "Wrong directory name to delete: " + dir;
            throw new Error(msg);
        }
        String dirName = dir.getName();
        boolean isDataManDir = dirName.startsWith("datam");
        boolean foundDataManRemovalMarker = false;
        HashSet<File> excluded = new HashSet<File>();
        HashSet noted = new HashSet();
        File[] files = FileCollector.listFiles(dir);
        if (files == null) {
            return;
        }
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            foundDataManRemovalMarker |= this.checkFileForExclusion(file, dir, currentTime, noted, excluded, isDataManDir);
        }
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            String name = files[i].getName();
            File target = null;
            if (FileCollector.isShortExpirationMarker(name)) {
                String path;
                String delPath;
                long disposalTime = FileCollector.expirationFromShortMarker(file);
                if (currentTime > disposalTime || noted.contains(delPath = (path = file.getAbsolutePath()) + ".del")) continue;
                excluded.add(file);
                continue;
            }
            if (name.endsWith(".del")) {
                target = new File(dir, file.getName() + ".del");
                String targetPath = file.getAbsolutePath();
                if (!noted.contains(targetPath = targetPath.substring(0, targetPath.length() - ".del".length()))) continue;
                excluded.add(file);
                continue;
            }
            if (!FileCollector.isSessionMarker(name)) continue;
            target = new File(dir, FileCollector.getFileFromSessionMarker(name));
            if (excluded.contains(target)) {
                excluded.add(file);
                continue;
            }
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].equals(target)) continue;
                excluded.add(file);
                excluded.add(target);
            }
        }
        if (isDataManDir && !foundDataManRemovalMarker) {
            return;
        }
        HashSet<File> deleted = null;
        if (FileCollector.getDebugManagedFiles()) {
            deleted = new HashSet<File>();
        }
        boolean removedAll = true;
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file2 = files[i2];
            if (excluded.contains(file2)) continue;
            String name = file2.getName();
            if (name.endsWith(".stale")) {
                String targetName = name.substring(0, name.length() - ".stale".length());
                File target = new File(file2.getParent(), targetName);
                if (!excluded.contains(target) && !FileCollector.internalDelete(target) && target.exists()) continue;
            }
            if (deleted != null) {
                deleted.add(file2);
            }
            if (FileCollector.internalDelete(file2) || !file2.exists()) continue;
            removedAll = false;
            this.addStaleFile(file2);
            if (!dirName.startsWith("session")) continue;
            String session = dirName.substring("session".length());
            removedSessions.put(session, NO_MARKER);
        }
        if (deleted != null && deleted.size() > 0) {
            this.debugReportDeletionSituation(dir, removedSessions, currentTime, files, deleted, excluded);
        }
        if (removedAll && !FileCollector.internalDelete(dir) && isDataManDir && (files = FileCollector.listFiles(dir)) != null && files.length == 1 && FileCollector.isDataManRemovalMarker(files[0].getName())) {
            FileCollector.internalDelete(files[0]);
            FileCollector.internalDelete(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugReportDeletionSituation(File dir, Hashtable<String, File> removedSessions, long currentTime, File[] files, HashSet<File> deleted, HashSet<File> excluded) {
        if (!FileCollector.getDebugManagedFiles()) {
            return;
        }
        if (debugChanges == null || !debugChanges.contains("deletionSituation")) {
            return;
        }
        try {
            OutputStream os = null;
            try {
                Properties props = new Properties();
                props.setProperty("deletionParentDirectory", dir.getAbsolutePath());
                props.setProperty("isDataManDir", Boolean.toString(dir.getName().startsWith("datam")));
                for (Map.Entry<String, File> o : removedSessions.entrySet()) {
                    props.setProperty("removedSession" + o.getKey(), o.getValue().getAbsolutePath());
                }
                if (removedSessions.size() == 0) {
                    props.setProperty("noRemovedSessions", "true");
                }
                props.setProperty("currenTime", Long.toString(currentTime));
                for (int i = 0; i < files.length; ++i) {
                    String filePropertyName = "file" + Integer.toString(1000 + i);
                    props.setProperty(filePropertyName, files[i].getAbsolutePath());
                    File file = files[i];
                    String name = file.getName();
                    if (FileCollector.isShortExpirationMarker(name)) {
                        long disposalTime = FileCollector.expirationFromShortMarker(file);
                        props.setProperty(filePropertyName + "ShortMarkerDisposalTime", Long.toString(disposalTime));
                    }
                    if (FileCollector.isExpirationMarker(name)) {
                        File target = new File(dir, FileCollector.getFileFromExpirationMarker(name));
                        props.setProperty(filePropertyName + "ExpirationMarkerTargetFile", target.getAbsolutePath());
                    }
                    if (FileCollector.isDataManRemovalMarker(name)) {
                        props.setProperty(filePropertyName + "IsDataManRemovalMarker", "true");
                    }
                    if (name.endsWith(".del")) {
                        File target = new File(file.getParent(), file.getName().substring(0, file.getName().length() - ".del".length()));
                        props.setProperty(filePropertyName + "DeletionMarkerTargetFile", target.getAbsolutePath());
                    }
                    if (FileCollector.isSessionMarker(name)) {
                        File target = new File(dir, FileCollector.getFileFromSessionMarker(name));
                        props.setProperty(filePropertyName + "SessionMarkerTargetFile", target.getAbsolutePath());
                    }
                    props.setProperty(filePropertyName + "Deleted", Boolean.toString(deleted.contains(file)));
                }
                int idx = 1000;
                for (File f : deleted) {
                    props.setProperty("deleted" + Integer.toString(idx++), f.getAbsolutePath());
                }
                idx = 1000;
                for (File f : excluded) {
                    props.setProperty("excluded" + Integer.toString(idx++), f.getAbsolutePath());
                }
                os = FileCollector.newDebugOutputStream(dir, "deletionSituation");
                if (os == null) {
                    return;
                }
                props.storeToXML(os, "Deletion situation");
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.fine(this.toString() + " started");
        while (true) {
            int reportedStaleFiles = 0;
            try {
                Thread.sleep(FileCollector.getSleepTime());
                boolean foundDirs = false;
                boolean foundFiles = false;
                Iterator<File> roots = _rootEntries.keySet().iterator();
                while (roots.hasNext()) {
                    try {
                        this.resetStaleFileCounts();
                        File rootDir = roots.next();
                        if (BackupUtil.isBackupRoot(rootDir)) {
                            BackupUtil.executeQueuedDeletions(BackupUtil.deletionStage);
                        }
                        long timeSkewDelta = _rootEntries.get(rootDir);
                        Hashtable<String, File> removedSessions = new Hashtable<String, File>();
                        long currentTime = System.currentTimeMillis() - timeSkewDelta;
                        foundFiles |= this.collectFiles(rootDir, currentTime, removedSessions);
                        foundDirs |= this.collectDirs(rootDir, currentTime, removedSessions);
                    }
                    catch (Throwable e) {
                        logger.log(e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"collecting temp files");
                    }
                    finally {
                        reportedStaleFiles = this.reportStaleFiles();
                    }
                }
                if (foundFiles || foundDirs) continue;
            }
            catch (Throwable e) {
                logger.log(e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"collecting temp files");
                continue;
            }
            finally {
                switch (reportedStaleFiles) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        lastInfoReportTime = this.cTime;
                        break;
                    }
                    case 2: {
                        lastInfoReportTime = this.cTime;
                        this.lastWarningReportTime = this.cTime;
                    }
                }
                continue;
            }
            break;
        }
        _collectorThread = null;
        logger.finer(this.toString() + " ends since there is nothing to collect");
    }

    private static String formatBytes(long kbytes) {
        if (kbytes == 0L) {
            return "0";
        }
        long m = kbytes / 1024L;
        if (m == 0L) {
            return "<1";
        }
        return Long.toString(m);
    }

    private int reportStaleFiles() {
        try {
            if (this.totalStaleFiles >= 10 || this.totalStaleSize >= 10240L) {
                if (this.lastWarningReportTime < this.cTime - (long)DELETION_REPORT_INTERVAL_WARNING) {
                    logger.log(UtilMsg.FILES_UNREMOVABLE_SIZE_WARNING, (Object)FileCollector.formatBytes(this.totalStaleSize), (Object)FileCollector.formatBytes(this.staleSizeInLastHour), (Object)FileCollector.formatBytes(this.staleSizeInLast24Hours), (Object)FileCollector.formatBytes(this.staleSizeInLastWeek));
                    logger.log(UtilMsg.FILES_UNREMOVABLE_COUNT_WARNING, (Object)this.totalStaleFiles, (Object)this.staleInLastHour, (Object)this.staleInLast24Hours, (Object)this.staleInLastWeek);
                    logger.log(UtilMsg.FILES_UNREMOVABLE_SAMPLE);
                    for (File f : this.sampleStaleFiles) {
                        File stale = new File(f.getParent(), f.getName() + ".stale");
                        long staleTime = stale.lastModified();
                        long delta = this.cTime - staleTime;
                        long attempts = delta / FileCollector.getSleepTime();
                        if (attempts < 1L || staleTime == 0L) {
                            attempts = 1L;
                        }
                        logger.log(UtilMsg.FAILED_TO_DELETE_FILE_AFTER_N_ATTEMPTS, (Object)f.getAbsolutePath(), (Object)attempts);
                    }
                    return 2;
                }
            } else if (lastInfoReportTime < this.cTime - (long)DELETION_REPORT_INTERVAL_INFO && this.totalStaleFiles > 0 && logger.isLoggable(Level.INFO)) {
                lastInfoReportTime = this.cTime;
                logger.log(UtilMsg.FILES_UNREMOVABLE_SIZE_INFO, (Object)FileCollector.formatBytes(this.totalStaleSize), (Object)FileCollector.formatBytes(this.staleSizeInLastHour), (Object)FileCollector.formatBytes(this.staleSizeInLast24Hours), (Object)FileCollector.formatBytes(this.staleSizeInLastWeek));
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static boolean isSessionMarker(String marker) {
        return marker.lastIndexOf(".session") > 0;
    }

    public static String getSessionFromSessionMarker(String marker) {
        int i = marker.lastIndexOf(".session");
        return marker.substring(i + ".session".length());
    }

    public static String getFileFromSessionMarker(String marker) {
        return marker.substring(0, marker.lastIndexOf(".session"));
    }

    public static boolean isShortExpirationMarker(String marker) {
        return marker.length() == 32 && marker.charAt(0) >= 'g' && marker.charAt(0) <= 'z' && marker.charAt(marker.length() - 7) == '0';
    }

    public static boolean isExpirationMarker(String marker) {
        return marker.lastIndexOf(".expiresOn") > 0;
    }

    public static long getTimeFromExpirationMarker(String marker) {
        int i = marker.lastIndexOf(".expiresOn");
        return Long.parseLong(marker.substring(i + ".expiresOn".length()));
    }

    public static String getFileFromExpirationMarker(String marker) {
        return marker.substring(0, marker.lastIndexOf(".expiresOn"));
    }

    public static boolean isDataManRemovalMarker(String marker) {
        return marker.equals("remove");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNextInvocationSessionId() {
        Object object = _invocationIdMutex;
        synchronized (object) {
            ++_invocationId;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(INVOCATION_SESSION_PREFIX);
        sb.append(Platform.UTIL.getServerInstanceId());
        sb.append("-");
        sb.append(_runId);
        sb.append("-");
        sb.append(_invocationId);
        return sb.toString();
    }

    private static class ChangeSequenceCounter {
        int count = 0;

        private ChangeSequenceCounter() {
        }
    }
}

