/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.service.DataBuffer;
import com.adobe.service.DataManager;
import com.adobe.service.FileDataBuffer;
import com.adobe.service.FileDataBufferHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.omg.CORBA.Object;

public class DMUtils {
    private static int BUFFER_SIZE = 10240;

    public static DataBuffer getDataBuffer(DataManager dm, InputStream is) {
        FileDataBuffer fdb = null;
        String tempFileName = dm.getTempFileName(true);
        try {
            if (DMUtils.copyFile(is, tempFileName)) {
                fdb = dm.createFileDataBuffer(tempFileName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return fdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataBuffer getDataBuffer(DataManager dm, DataHandler dh) {
        FileDataBuffer fdb = null;
        String tempFileName = dm.getTempFileName(true);
        try {
            String contentType = dh.getContentType();
            InputStream is = dh.getInputStream();
            try {
                if (DMUtils.copyFile(is, tempFileName) && (fdb = dm.createFileDataBuffer(tempFileName)) != null) {
                    fdb.setContentType(contentType);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return fdb;
    }

    public static DataHandler getDataHandler(DataManager dm, DataBuffer db) {
        DataHandler dh = null;
        FileDataBuffer fdb = FileDataBufferHelper.narrow((Object)db);
        if (fdb != null) {
            dh = new DataHandler((DataSource)new FileDataSource(fdb.getFilePath()));
        }
        return dh;
    }

    public static InputStream getInputStream(DataManager dm, DataBuffer db) {
        FileInputStream is = null;
        FileDataBuffer fdb = FileDataBufferHelper.narrow((Object)db);
        if (fdb != null) {
            try {
                is = new FileInputStream(fdb.getFilePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return is;
    }

    private static boolean copyFile(InputStream is, String filePath) {
        boolean retVal = false;
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            FileOutputStream outStream = new FileOutputStream(filePath);
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            outStream.close();
            retVal = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

