/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx.statistics;

import com.adobe.jmx.statistics.Statistic;
import com.adobe.jmx.statistics.StatisticsHost;
import com.adobe.jmx.statistics.TimeStatisticAttributes;
import com.adobe.util.Peer;

public abstract class TimeStatistic
extends Statistic
implements TimeStatisticAttributes {
    private static final Factory factory = (Factory)Peer.getFactory(TimeStatistic.class);
    long count = 0L;
    long maxTime = 0L;
    long minTime = Long.MAX_VALUE;
    long totalTime = 0L;

    TimeStatistic(StatisticsHost host, String name) {
        super(host, name);
        this.addReflectionTarget(this, TimeStatisticAttributes.class);
    }

    public static final TimeStatistic create(StatisticsHost host, String name) {
        return factory.create(host, name);
    }

    public synchronized String getUnit() {
        return "MILLISECOND";
    }

    public synchronized long getCount() {
        return this.count;
    }

    public synchronized long getMaxTime() {
        return this.maxTime;
    }

    public synchronized long getMinTime() {
        return this.minTime;
    }

    public synchronized double getMean() {
        if (this.count <= 0L) {
            return 0.0;
        }
        return (double)this.totalTime / (double)this.count;
    }

    public double getDutyCycle() {
        long elapse = this.lastSampleTime - this.startTime;
        if (elapse <= 0L) {
            return 0.0;
        }
        return (double)this.totalTime / (double)elapse;
    }

    public synchronized long getTotalTime() {
        return this.totalTime;
    }

    public long begin() {
        return TimeStatistic.currentTime();
    }

    public void end(long start) {
        this.accumulate(TimeStatistic.currentTime() - start);
    }

    public synchronized void accumulate(long time) {
        this.lastSampleTime = TimeStatistic.currentTime();
        ++this.count;
        this.totalTime += time;
        if (this.minTime > time) {
            this.minTime = time;
        }
        if (this.maxTime < time) {
            this.maxTime = time;
        }
    }

    public synchronized void bulkUpdate(long samples, long tot, long min, long max) {
        this.lastSampleTime = TimeStatistic.currentTime();
        this.count += samples;
        this.totalTime += tot;
        if (this.minTime > min) {
            this.minTime = min;
        }
        if (this.maxTime < max) {
            this.maxTime = max;
        }
    }

    public synchronized void reset() {
        this.count = 0L;
        this.lastSampleTime = 0L;
        this.startTime = TimeStatistic.currentTime();
        this.maxTime = 0L;
        this.totalTime = 0L;
        this.minTime = Long.MAX_VALUE;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TimeStatistic(");
        buf.append(this.name);
        buf.append(':');
        buf.append(this.minTime);
        buf.append('<');
        buf.append(this.maxTime);
        buf.append('=');
        buf.append(this.totalTime);
        buf.append('#');
        buf.append(this.count);
        if (this.description != null && this.description.length() != 0) {
            buf.append(", ");
            buf.append(this.description);
        }
        buf.append(')');
        return buf.toString();
    }

    static interface Factory {
        public TimeStatistic create(StatisticsHost var1, String var2);
    }
}

