/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx.statistics;

import com.adobe.jmx.DynamicImpl;
import com.adobe.jmx.JmxPortability;
import com.adobe.jmx.statistics.StatisticAttributes;
import com.adobe.jmx.statistics.StatisticsHost;
import com.adobe.jmx.statistics.StatisticsProvider;
import javax.management.ObjectName;

public abstract class Statistic
extends DynamicImpl
implements StatisticAttributes {
    protected final String name;
    protected final StatisticsProvider statisticsProvider;
    protected final String description;
    protected long startTime = Statistic.currentTime();
    protected long lastSampleTime = 0L;

    protected Statistic(StatisticsHost host, String name) {
        super((Class)null);
        this.name = name;
        this.statisticsProvider = host.getStatisticsProvider();
        this.addReflectionTarget(this, StatisticAttributes.class);
        this.statisticsProvider.addStat(this);
        this.description = this.statisticsProvider.getAttributeDescription(name);
        if (this instanceof DynamicImpl.Attr) {
            this.statisticsProvider.addAttr(this.name, (DynamicImpl.Attr)((Object)this));
        }
    }

    ObjectName getObjectName() {
        return JmxPortability.makeName(this.statisticsProvider.getObjectName(), JmxPortability.ADOBE_STAT_TYPE, this.name);
    }

    protected static final long currentTime() {
        return System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public synchronized String getUnit() {
        return "ITEM";
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized long getLastSampleTime() {
        return this.lastSampleTime;
    }

    protected String getMBeanDescription() {
        return this.description;
    }
}

