/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx.statistics;

import com.adobe.jmx.Notifier;
import com.adobe.jmx.statistics.Statistic;
import com.adobe.jmx.statistics.StatisticsHost;
import com.adobe.statistics.TimeWeightedMeanAndVariance;

public abstract class RangeStatisticBase
extends Statistic {
    private long rangeHighThreshold = 0L;
    private boolean rangeHiThresholdExceeded = false;
    long current = 0L;
    long highWaterMark = Long.MIN_VALUE;
    long lowWaterMark = Long.MAX_VALUE;
    TimeWeightedMeanAndVariance meanAndVariance = new TimeWeightedMeanAndVariance();

    RangeStatisticBase(StatisticsHost host, String name) {
        super(host, name);
        if (this.statisticsProvider.rangeThresholdNotifier == null) {
            this.statisticsProvider.rangeThresholdNotifier = new Notifier(this.statisticsProvider, "adobe.threshold.Range");
        }
    }

    public synchronized long getCurrent() {
        return this.current;
    }

    public synchronized long getHighWaterMark() {
        return this.highWaterMark;
    }

    public synchronized long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public synchronized double getMean() {
        return this.meanAndVariance.getMean();
    }

    public synchronized double getVariance() {
        return this.meanAndVariance.getVariance();
    }

    public synchronized void setCurrent(long n) {
        this.lastSampleTime = RangeStatisticBase.currentTime();
        this.current = n;
        if (this.lowWaterMark > n) {
            this.lowWaterMark = n;
        }
        if (this.highWaterMark < n) {
            this.highWaterMark = n;
        }
        this.meanAndVariance.accumulate(n);
        this.checkThresholds();
    }

    public synchronized void increment(long incr) {
        this.setCurrent(this.current + incr);
    }

    public synchronized void increment() {
        this.setCurrent(this.current + 1L);
    }

    public synchronized void decrement() {
        this.setCurrent(this.current - 1L);
    }

    public synchronized void reset(long n) {
        this.reset();
        this.setCurrent(n);
    }

    public synchronized void reset() {
        this.lastSampleTime = 0L;
        this.startTime = RangeStatisticBase.currentTime();
        this.highWaterMark = Long.MIN_VALUE;
        this.current = 0L;
        this.lowWaterMark = Long.MAX_VALUE;
    }

    public synchronized void setHighThreshold(long countThreshold) {
        this.rangeHighThreshold = countThreshold;
        this.rangeHiThresholdExceeded = false;
        this.checkThresholds();
    }

    public synchronized long getHighThreshold() {
        return this.rangeHighThreshold;
    }

    private void checkThresholds() {
        if (this.rangeHighThreshold > 0L && this.current > this.rangeHighThreshold) {
            if (!this.rangeHiThresholdExceeded) {
                this.rangeHiThresholdExceeded = true;
                this.statisticsProvider.rangeThresholdNotifier.fire(this.name, this);
            }
        } else {
            this.rangeHiThresholdExceeded = false;
        }
    }
}

