/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx.statistics;

import com.adobe.jmx.Notifier;
import com.adobe.jmx.statistics.CountStatisticAttributes;
import com.adobe.jmx.statistics.Statistic;
import com.adobe.jmx.statistics.StatisticsHost;
import com.adobe.statistics.LowPassFilter;
import com.adobe.util.Peer;

public abstract class CountStatistic
extends Statistic
implements CountStatisticAttributes {
    private static final Factory factory = (Factory)Peer.getFactory(CountStatistic.class);
    private long countThreshold = 0L;
    private boolean countThresholdExceeded = false;
    long count = 0L;
    long lastNonZeroDeltaTime = 0L;
    private final LowPassFilter rate = new LowPassFilter(60000.0);

    CountStatistic(StatisticsHost host, String name) {
        super(host, name);
        this.addReflectionTarget(this, CountStatisticAttributes.class);
        if (this.statisticsProvider.countThresholdNotifier == null) {
            this.statisticsProvider.countThresholdNotifier = new Notifier(this.statisticsProvider, "adobe.threshold.Count");
        }
    }

    public static CountStatistic create(StatisticsHost host, String name) {
        return factory.create(host, name);
    }

    public synchronized long getCount() {
        return this.count;
    }

    public void increment() {
        this.increment(1L);
    }

    public synchronized void increment(long n) {
        this.count += n;
        long eventTime = CountStatistic.currentTime();
        this.checkThresholds();
        if (this.lastSampleTime != 0L) {
            long deltaT = eventTime - this.lastSampleTime;
            if (deltaT > 0L) {
                double dt = deltaT;
                this.rate.accumulate((double)n / dt, dt);
                this.lastNonZeroDeltaTime = this.lastSampleTime;
            } else if (this.lastNonZeroDeltaTime != 0L && (deltaT = eventTime - this.lastNonZeroDeltaTime) != 0L) {
                double dt = deltaT;
                this.rate.fixupLastSample((double)n / dt, dt);
            }
        }
        this.lastSampleTime = eventTime;
    }

    public void reset() {
        this.reset(0L);
    }

    public synchronized void reset(long n) {
        this.count = n;
        this.rate.reset();
        this.countThresholdExceeded = false;
        this.startTime = CountStatistic.currentTime();
        this.lastSampleTime = 0L;
        this.lastNonZeroDeltaTime = 0L;
    }

    public synchronized double getRate() {
        long elapse = this.lastSampleTime - this.startTime;
        if (elapse <= 0L) {
            return 0.0;
        }
        return (double)this.count / (double)elapse * 1000.0;
    }

    public synchronized double getCurrentRate() {
        return this.rate.getMean() * 1000.0;
    }

    public synchronized double getCurrentRateSmoothing() {
        return this.rate.getTimeConstant() / 1000.0;
    }

    public synchronized void setCurrentRateSmoothing(double timeConstant) {
        this.rate.setTimeConstant(timeConstant * 1000.0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CountStatistic(");
        buf.append(this.name);
        buf.append(':');
        buf.append(this.count);
        if (this.description != null && this.description.length() != 0) {
            buf.append(", ");
            buf.append(this.description);
        }
        buf.append(')');
        return buf.toString();
    }

    public synchronized void setThreshold(long countThreshold) {
        this.countThreshold = countThreshold;
        this.countThresholdExceeded = false;
        this.checkThresholds();
    }

    public synchronized long getThreshold() {
        return this.countThreshold;
    }

    private void checkThresholds() {
        if (this.countThreshold > 0L && this.count > this.countThreshold) {
            if (!this.countThresholdExceeded) {
                this.countThresholdExceeded = true;
                this.statisticsProvider.countThresholdNotifier.fire(this.name, this);
            }
        } else {
            this.countThresholdExceeded = false;
        }
    }

    static interface Factory {
        public CountStatistic create(StatisticsHost var1, String var2);
    }
}

