/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx;

import com.adobe.jmx.JmxPortability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameTreeNode {
    final ObjectName name;
    ObjectNameTreeNode parent = null;
    Collection childList = new ArrayList();
    ObjectNameTreeNode[] children;
    String relativeDisplayName;
    private static final ObjectNameTreeNode[] emptyObjectNameTreeNode = new ObjectNameTreeNode[0];

    public static ObjectNameTreeNode[] createNameTree(Collection objectNames) {
        String n1;
        String t1;
        Hashtable<String, String> h;
        HashMap<String, ObjectNameTreeNode> namesMap = new HashMap<String, ObjectNameTreeNode>();
        Iterator<Object> iter = objectNames.iterator();
        while (iter.hasNext()) {
            ObjectName lookupName;
            ObjectNameTreeNode node = new ObjectNameTreeNode((ObjectName)iter.next());
            h = new Hashtable<String, String>();
            h.putAll(node.name.getKeyPropertyList());
            t1 = (String)h.remove(JmxPortability.TYPE_STRING);
            n1 = (String)h.remove(JmxPortability.NAME_STRING);
            if (t1 != null && n1 != null) {
                h.put(t1, n1);
            }
            try {
                lookupName = new ObjectName(node.name.getDomain(), h);
            }
            catch (MalformedObjectNameException e) {
                lookupName = node.name;
            }
            namesMap.put(lookupName.getCanonicalName(), node);
        }
        for (ObjectNameTreeNode node : namesMap.values()) {
            ObjectName parentName;
            h = new Hashtable();
            h.putAll(node.name.getKeyPropertyList());
            t1 = (String)h.remove(JmxPortability.TYPE_STRING);
            n1 = (String)h.remove(JmxPortability.NAME_STRING);
            try {
                parentName = t1 != null && n1 != null ? new ObjectName(node.name.getDomain(), h) : (ObjectName)JmxPortability.mBeanServer.getAttribute(node.name, "Parent");
            }
            catch (Exception e) {
                continue;
            }
            ObjectNameTreeNode parent = (ObjectNameTreeNode)namesMap.get(parentName.getCanonicalName());
            if (parent == null) continue;
            node.relativeDisplayName = t1 + '=' + n1;
            node.parent = parent;
            parent.childList.add(node);
        }
        ArrayList<ObjectNameTreeNode> res = new ArrayList<ObjectNameTreeNode>();
        for (ObjectNameTreeNode node : namesMap.values()) {
            node.children = node.childList.toArray(emptyObjectNameTreeNode);
            node.childList = null;
            if (node.parent != null) continue;
            res.add(node);
        }
        return res.toArray(emptyObjectNameTreeNode);
    }

    ObjectNameTreeNode(ObjectName name) {
        this.name = name;
        this.relativeDisplayName = name.getCanonicalName();
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public String getRelativeDisplayName() {
        return this.relativeDisplayName;
    }

    public ObjectNameTreeNode getParent() {
        return this.parent;
    }

    public ObjectNameTreeNode[] getChildArray() {
        return this.children;
    }
}

