/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.xml.sax.SAXException;

public final class XMLUtilities {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    private XMLUtilities() {
    }

    public static org.w3c.dom.Document readXML(String inXMLFile, ClassLoader inClassLoader) throws SAXException {
        InputStream xmlFile = inClassLoader.getResourceAsStream(inXMLFile);
        return XMLUtilities.readXML(xmlFile);
    }

    public static org.w3c.dom.Document readXML(InputStream inXMLStream) throws SAXException {
        org.w3c.dom.Document result = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            result = db.parse(inXMLStream);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        return result;
    }

    public static Map xmlToMap(InputStream inXML) throws SAXException {
        final HashMap xmlMap = new HashMap();
        try {
            VisitorSupport xmlMapper = new VisitorSupport(){

                public void visit(Text elem) {
                    xmlMap.put(elem.getParent().getQName().getQualifiedName(), elem.getText());
                }
            };
            DOMReader reader = new DOMReader();
            Document dom = reader.read(XMLUtilities.readXML(inXML));
            dom.accept((Visitor)xmlMapper);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        return new HashMap(xmlMap);
    }

    public static org.w3c.dom.Document mapToXML(String inRootName, Map inMap) throws SAXException {
        org.w3c.dom.Document result = null;
        DOMWriter writer = new DOMWriter();
        DocumentFactory factory = DocumentFactory.getInstance();
        Element root = factory.createElement(inRootName);
        Document doc = factory.createDocument(root);
        try {
            for (String name : inMap.keySet()) {
                String value = (String)inMap.get(name);
                Element elem = factory.createElement(name);
                elem.add(factory.createText(value));
                root.add(elem);
            }
            result = writer.write(doc);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        return result;
    }

    public static org.w3c.dom.Document readValidatedXML(String inXMLFile, ClassLoader inClassLoader) throws SAXException {
        InputStream xmlFile = inClassLoader.getResourceAsStream(inXMLFile);
        return XMLUtilities.readValidatedXML(xmlFile, null);
    }

    public static org.w3c.dom.Document readValidatedXML(String inXMLFile, String inXMLSchemaFile, ClassLoader inClassLoader) throws SAXException {
        InputStream xmlFile = inClassLoader.getResourceAsStream(inXMLFile);
        InputStream schemaFile = inClassLoader.getResourceAsStream(inXMLSchemaFile);
        return XMLUtilities.readValidatedXML(xmlFile, schemaFile);
    }

    public static org.w3c.dom.Document readValidatedXML(InputStream inXMLStream, InputStream inSchemaStream) throws SAXException {
        org.w3c.dom.Document result = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            if (inSchemaStream != null) {
                dbf.setAttribute(JAXP_SCHEMA_SOURCE, inSchemaStream);
            }
            DocumentBuilder db = dbf.newDocumentBuilder();
            result = db.parse(inXMLStream);
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
        return result;
    }
}

