/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import com.adobe.framework.AdobeJarSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JarInputSupport
extends AdobeJarSupport {
    private JarInputStream jarStream = null;

    public JarInputSupport(InputStream inStream, boolean inCheckTimeStamp) throws IOException {
        super(inCheckTimeStamp);
        this.initJarSupport(inStream);
    }

    public void extractAll(String inDirectory, boolean inPersist) throws IOException {
        this.extractAll(inDirectory, inPersist, false);
    }

    public void extractAll(String inDirectory, boolean inPersist, boolean setSharedXbit) throws IOException {
        File directory = new File(inDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (directory.isDirectory()) {
            JarEntry entry;
            while ((entry = this.jarStream.getNextJarEntry()) != null) {
                this.unjar(directory, this.jarStream, entry, inPersist, setSharedXbit);
            }
        }
    }

    public void close() throws IOException {
        this.jarStream.close();
    }

    private void initJarSupport(InputStream inStream) throws IOException {
        this.jarStream = new JarInputStream(new BufferedInputStream(inStream));
        this.setManifest(this.jarStream.getManifest());
    }
}

