/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import com.adobe.framework.AdobeJarSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileSupport
extends AdobeJarSupport {
    private JarFile jarFile = null;
    private Map jarEntries = new HashMap();

    public JarFileSupport(File inFile, boolean inCheckTimeStamp) throws IOException {
        super(inCheckTimeStamp);
        this.initJarSupport(inFile);
    }

    public Collection getEntries() {
        return this.jarEntries.values();
    }

    public Collection getNames() {
        return this.jarEntries.keySet();
    }

    public JarEntry getEntry(String inName) {
        return (JarEntry)this.jarEntries.get(inName);
    }

    public void extractItem(String inEntryName, String inDirectory, boolean inPersist) throws IOException {
        File directory = new File(inDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
            if (!inPersist) {
                directory.deleteOnExit();
            }
        }
        if (directory.isDirectory()) {
            this.unjar(directory, this.getInputStream(inEntryName), (JarEntry)this.jarEntries.get(inEntryName), inPersist);
        }
    }

    public void extractAll(String inDirectory, boolean inPersist) throws IOException {
        this.extractAll(inDirectory, inPersist, false);
    }

    public void extractAll(String inDirectory, boolean inPersist, boolean setSharedXbit) throws IOException {
        File directory = new File(inDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
            if (!inPersist) {
                directory.deleteOnExit();
            }
        }
        if (directory.isDirectory()) {
            for (String entryName : this.jarEntries.keySet()) {
                InputStream dataStream = this.getInputStream(entryName);
                this.unjar(directory, dataStream, (JarEntry)this.jarEntries.get(entryName), inPersist, setSharedXbit);
                dataStream.close();
            }
        }
    }

    public InputStream getInputStream(String inName) {
        InputStream jis = null;
        try {
            if (this.jarFile != null) {
                ZipEntry ze = this.jarFile.getEntry(inName);
                jis = this.jarFile.getInputStream(ze);
            }
        }
        catch (IOException ex) {
            jis = null;
        }
        return jis;
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    private void initJarSupport(File inFile) throws IOException {
        this.jarFile = new JarFile(inFile);
        if (this.jarFile != null) {
            this.setManifest(this.jarFile.getManifest());
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.jarEntries.put(entry.getName(), entry);
            }
        }
    }
}

