/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.Platform;
import java.io.File;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.iiop.CorbaORB;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.server.ServerConfigLocator;
import org.omg.CORBA.ORB;

public class PlatformImpl
extends Platform {
    private ORB orb = null;
    private InitialContext _serverSideContext = null;

    public synchronized ORB getOrb() {
        if (this.orb == null) {
            this.orb = CorbaORB.getInstance();
        }
        return this.orb;
    }

    public File getWorkspaceRootDir() {
        File adobeServerRoot = ServerConfigLocator.locate().getServerHomeDir();
        File nativeHome = new File(adobeServerRoot, "svcnative");
        return nativeHome;
    }

    public synchronized void setServerInstanceId() {
        if (System.getProperty("com.adobe.serverInstanceId") == null) {
            String serverInstanceId = "adobejb";
            serverInstanceId = serverInstanceId + "_" + System.getProperty("adobeidp.serverName");
            System.setProperty("com.adobe.serverInstanceId", serverInstanceId);
        }
    }

    public InitialContext getServerSideContext() throws Exception {
        if (this._serverSideContext == null) {
            try {
                InitialContext ctx = new InitialContext();
                MBeanServer server = MBeanServerLocator.locateJBoss();
                boolean discoveryDisabled = true;
                try {
                    discoveryDisabled = (Boolean)server.getAttribute(new ObjectName("jboss:service=HAJNDI"), "DiscoveryDisabled");
                }
                catch (JMException je) {
                    // empty catch block
                }
                if (discoveryDisabled) {
                    this._serverSideContext = new InitialContext();
                } else {
                    String partitionNameAttrib = (String)server.getAttribute(new ObjectName("jboss:service=HAJNDI"), "PartitionName");
                    Properties props = new Properties();
                    props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                    props.put("java.naming.factory.url.pkgs", "jboss.naming:org.jnp.interfaces");
                    props.put("jnp.partitionName", partitionNameAttrib);
                    this._serverSideContext = new InitialContext(props);
                }
            }
            catch (NamingException ne) {
                this._serverSideContext = null;
                throw new Exception(ne.getMessage(), ne.getCause());
            }
            catch (JMException je) {
                this._serverSideContext = null;
                throw new Exception(je.getMessage(), je.getCause());
            }
        }
        return this._serverSideContext;
    }
}

