/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.jmx.JmxPortability;
import com.adobe.logging.AdobeLogger;
import com.adobe.service.ConnectionFactory;
import com.adobe.util.Peer;
import com.adobe.util.UtilMsg;
import com.adobe.util.Utilities;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.omg.CORBA.ORB;

public abstract class Platform {
    protected static final AdobeLogger logger = AdobeLogger.getAdobeLogger(Platform.class);
    public static final Platform UTIL = (Platform)Peer.getSingleton(Platform.class);
    public final String serverInstanceIdKey = "com.adobe.serverInstanceId";
    private TransactionManager transactionManager = null;
    String pass = "";
    Boolean bSSL = null;

    Platform() {
    }

    public abstract ORB getOrb();

    public abstract File getWorkspaceRootDir();

    public String getServerInstanceId() {
        if (System.getProperty("com.adobe.serverInstanceId") == null) {
            this.setServerInstanceId();
        }
        return System.getProperty("com.adobe.serverInstanceId");
    }

    public abstract void setServerInstanceId();

    public abstract InitialContext getServerSideContext() throws Exception;

    public URLConnection getUrlConnection(String urlStr) {
        URLConnection con = null;
        try {
            URL url = new URL(urlStr);
            con = url.openConnection();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
        return con;
    }

    public TransactionManager getTransactionManager() {
        try {
            if (this.transactionManager == null) {
                InitialContext namingContext = new InitialContext();
                this.transactionManager = (TransactionManager)namingContext.lookup(this.getTransactionManagerJNDIName());
            }
            return this.transactionManager;
        }
        catch (NamingException e) {
            throw new IllegalStateException("No transaction manager " + e);
        }
    }

    protected String getTransactionManagerJNDIName() {
        return "java:/TransactionManager";
    }

    public synchronized String getSSLPassword() {
        if (this.bSSL != null) {
            if (this.bSSL.booleanValue()) {
                return this.pass;
            }
            return null;
        }
        final MBeanServer mbs = JmxPortability.mBeanServer;
        final ObjectName name = JmxPortability.makeName(JmxPortability.ADOBE_SERVICE_TYPE, "DataManagerService");
        try {
            this.bSSL = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
                    return mbs.getAttribute(name, "EnableSSL");
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.log((Throwable)e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"getting ssl flag, assume false.");
            this.bSSL = new Boolean(false);
        }
        if (this.bSSL == null) {
            logger.log(UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"ssl flag is not available yet");
            return null;
        }
        if (this.bSSL.booleanValue()) {
            try {
                this.pass = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
                        return mbs.getAttribute(name, "KeyPass");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                logger.log((Throwable)e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"getting encoded KeyPass");
            }
            return this.pass;
        }
        return null;
    }

    public boolean isLC7CompatibilityEnabled() {
        String val = System.getProperty("com.adobe.idp.enableLC7Compatibility");
        if (val != null) {
            return val.equalsIgnoreCase("true");
        }
        ConnectionFactory pdfSvc = null;
        boolean retVal = false;
        try {
            pdfSvc = Utilities.serviceLookup("PDFManipulation");
            retVal = true;
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return retVal;
    }
}

