/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.jmx.JmxPortability;
import com.adobe.logging.AdobeLogger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class CoreConfigUtil {
    private static AdobeLogger logger = AdobeLogger.getAdobeLogger(CoreConfigUtil.class);

    private CoreConfigUtil() {
    }

    public static Object getDataManagerJmxAttr(final String attrName) throws PrivilegedActionException {
        final MBeanServer mbs = JmxPortability.mBeanServer;
        final ObjectName name = JmxPortability.makeName(JmxPortability.ADOBE_SERVICE_TYPE, "DataManagerService");
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
                    return mbs.getAttribute(name, attrName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.debug((Throwable)e, "Failed to resolve \"" + attrName + "\" attribute.");
            throw e;
        }
    }

    public static Object getConfigParamAsObject(String paramName) {
        try {
            Object obj = CoreConfigUtil.getDataManagerJmxAttr(paramName);
            logger.debug("The \"" + paramName + "\" parameter was set in the DataManager service." + " The value is \"" + obj + "\"");
            return obj;
        }
        catch (Throwable t) {
            logger.debug(t, "Failed to resolve the \"" + paramName + "\" property via DataManager.");
            return null;
        }
    }

    public static String getConfigParamAsString(String paramName, String defaultVal) {
        String result = (String)CoreConfigUtil.getConfigParamAsObject(paramName);
        if (result == null || result.length() == 0) {
            result = defaultVal;
        }
        logger.debug("The \"" + paramName + "\" parameter " + " value is \"" + result + "\"");
        return result;
    }

    public static int getConfigParamAsInt(String paramName, int defaultVal) {
        int result;
        Object val = CoreConfigUtil.getConfigParamAsObject(paramName);
        if (val == null) {
            result = defaultVal;
        } else if (val instanceof Integer) {
            result = (Integer)val;
        } else {
            try {
                result = Integer.parseInt((String)val);
            }
            catch (NumberFormatException e) {
                result = defaultVal;
            }
        }
        logger.debug("The \"" + paramName + "\" parameter " + " value is \"" + result + "\"");
        return result;
    }

    public static boolean getConfigParamAsBoolean(String paramName, boolean defaultVal) {
        Object val = CoreConfigUtil.getConfigParamAsObject(paramName);
        boolean result = val == null ? defaultVal : (val instanceof Boolean ? ((Boolean)val).booleanValue() : new Boolean((String)val).booleanValue());
        logger.debug("The \"" + paramName + "\" parameter " + " value is \"" + result + "\"");
        return result;
    }
}

