/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.logging.AdobeLogger;
import com.adobe.service.ConnectionFactory;
import com.adobe.util.UtilMsg;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;

class ConnectionFactoryReflectionWrapper
implements ConnectionFactory {
    private Object _target;
    private Method _method;
    private static final AdobeLogger logger = AdobeLogger.getAdobeLogger(ConnectionFactoryReflectionWrapper.class);

    ConnectionFactoryReflectionWrapper(Object target) {
        this._target = target;
        Class<?> clazz = this._target.getClass();
        try {
            this._method = clazz.getMethod("getConnection", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public Object getConnection() throws RemoteException {
        try {
            return this._method.invoke(this._target, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            logger.log((Throwable)e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"resolving a new connection to an Adobe Service");
            throw new UndeclaredThrowableException(e, "An unexpected exception while resolving a new connection to an Adobe Service.");
        }
    }
}

