/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.BackupReservation;
import com.adobe.util.FileCollector;
import com.adobe.util.FileUtil;
import com.adobe.util.PropertiesInvocationHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class BackupUtil {
    public static final String trashPrefix = "tR";
    public static final String deletionPrefix = "dQ";
    public static final String deletionStageName = "ds";
    static File root = null;
    private static File backupRoot1 = null;
    public static File deletionStage = null;
    static File deletionDest = null;
    static File queueDest = null;
    static File backupReservationStage = null;
    static AtomicInteger deletionSerial = new AtomicInteger(0);
    static final int retries = 100;
    static int filePerDirCount = 0;
    static final DefaultBackupReservationValues defaultBackupReservationValues = new DefaultBackupReservationValues();
    public static final EmptyIterator emptyIterator = new EmptyIterator();
    private static boolean[] encode = new boolean[128];

    public static void setBackupRoot(File root) {
        try {
            BackupUtil.root = root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File[] listExistingRestoreOrBackup(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals("restore") || name.equals("backup");
            }
        };
        File[] list = FileCollector.listFiles(dir, filter);
        return list;
    }

    static File locateRestoreOrBackup() throws IOException {
        File[] list = BackupUtil.listExistingRestoreOrBackup(root);
        if (list == null) {
            File parent = root.getParentFile();
            list = FileCollector.listFiles(parent);
            if (list != null) {
                root.mkdirs();
                return null;
            }
            throw new IOException("No file list found!");
        }
        if (list.length < 1) {
            return null;
        }
        if (list.length < 2) {
            return list[0];
        }
        File localBackupRoot = null;
        File localRestoreRoot = null;
        boolean firstIsBackup = list[0].getName().equals("backup");
        if (firstIsBackup) {
            localBackupRoot = list[0];
            localRestoreRoot = list[1];
        } else {
            localBackupRoot = list[1];
            localRestoreRoot = list[0];
        }
        File reservation = null;
        reservation = BackupUtil.findReservation(localRestoreRoot, false);
        if (reservation != null) {
            final String keyName = "restored-" + reservation.getName() + ".txt";
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equals(keyName);
                }
            };
            list = FileCollector.listFiles(localBackupRoot, filter);
            if (list == null) {
                throw new IOException("No file list found!");
            }
            if (list.length < 1) {
                throw new RuntimeException(localBackupRoot + " is not consistent with " + localRestoreRoot + " no " + keyName + " file.");
            }
            return localBackupRoot;
        }
        throw new RuntimeException(localRestoreRoot + " has no reservation!" + "The restore may be corrupt. Please try another. Or proceed with caution " + "and start a new backup reservation as soon as possible if you need " + "continuous backup coverage.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean checkBackupRoot(int retry) {
        File localBackupRoot = new File(root, "backup");
        if (localBackupRoot.exists()) {
            boolean created;
            block42: {
                File flagFile = null;
                String name = Integer.toString(retry) + "." + FileUtil.getRandomFileNameBase64() + ".fl" + System.currentTimeMillis();
                flagFile = new File(localBackupRoot, name);
                created = false;
                created = flagFile.createNewFile();
                Object var8_5 = null;
                if (!created) break block42;
                flagFile.delete();
                backupRoot1 = new File(root, "backup");
                File reservation = BackupUtil.findReservation();
                if (reservation == null) {
                    deletionStage = new File(backupRoot1, deletionStageName);
                    File oldName = new File(backupRoot1, "deletionStage");
                    if (oldName.exists()) {
                        BackupUtil.renameFile(oldName, deletionStage);
                    } else {
                        deletionStage.mkdir();
                    }
                    String randomName = FileUtil.getRandomFileNameBase64();
                    name = trashPrefix + randomName;
                    File localDeletionDest = new File(deletionStage, name);
                    try {
                        if (localDeletionDest.mkdir()) {
                            try {
                                deletionDest = localDeletionDest.getCanonicalFile();
                            }
                            catch (IOException e2) {}
                        } else {
                            created = false;
                        }
                    }
                    finally {
                        if (deletionDest == null) {
                            localDeletionDest.delete();
                            created = false;
                        }
                    }
                    if (created && !BackupUtil.makeNewQueueDest(deletionStage)) {
                        localDeletionDest.delete();
                        created = false;
                    }
                } else {
                    created = BackupUtil.makeNewQueueDest(reservation);
                    {
                        break block42;
                        catch (IOException e) {
                            boolean bl = false;
                            Object var8_6 = null;
                            if (created) {
                                flagFile.delete();
                                backupRoot1 = new File(root, "backup");
                                reservation = BackupUtil.findReservation();
                                if (reservation == null) {
                                    deletionStage = new File(backupRoot1, deletionStageName);
                                    File oldName = new File(backupRoot1, "deletionStage");
                                    if (oldName.exists()) {
                                        BackupUtil.renameFile(oldName, deletionStage);
                                    } else {
                                        deletionStage.mkdir();
                                    }
                                    String randomName = FileUtil.getRandomFileNameBase64();
                                    name = trashPrefix + randomName;
                                    File localDeletionDest = new File(deletionStage, name);
                                    try {
                                        if (localDeletionDest.mkdir()) {
                                            try {
                                                deletionDest = localDeletionDest.getCanonicalFile();
                                            }
                                            catch (IOException e2) {}
                                        } else {
                                            created = false;
                                        }
                                    }
                                    finally {
                                        if (deletionDest == null) {
                                            localDeletionDest.delete();
                                            created = false;
                                        }
                                    }
                                    if (created && !BackupUtil.makeNewQueueDest(deletionStage)) {
                                        localDeletionDest.delete();
                                        created = false;
                                    }
                                } else {
                                    created = BackupUtil.makeNewQueueDest(reservation);
                                }
                            }
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        if (created) {
                            flagFile.delete();
                            backupRoot1 = new File(root, "backup");
                            reservation = BackupUtil.findReservation();
                            if (reservation == null) {
                                deletionStage = new File(backupRoot1, deletionStageName);
                                File oldName = new File(backupRoot1, "deletionStage");
                                if (oldName.exists()) {
                                    BackupUtil.renameFile(oldName, deletionStage);
                                } else {
                                    deletionStage.mkdir();
                                }
                                String randomName = FileUtil.getRandomFileNameBase64();
                                name = trashPrefix + randomName;
                                File localDeletionDest = new File(deletionStage, name);
                                try {
                                    if (localDeletionDest.mkdir()) {
                                        try {
                                            deletionDest = localDeletionDest.getCanonicalFile();
                                        }
                                        catch (IOException e2) {}
                                    } else {
                                        created = false;
                                    }
                                }
                                finally {
                                    if (deletionDest == null) {
                                        localDeletionDest.delete();
                                        created = false;
                                    }
                                }
                                if (created && !BackupUtil.makeNewQueueDest(deletionStage)) {
                                    localDeletionDest.delete();
                                    created = false;
                                }
                            } else {
                                created = BackupUtil.makeNewQueueDest(reservation);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            return created;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void makeBackupRoot() {
        if (backupRoot1 != null) return;
        Class<BackupUtil> clazz = BackupUtil.class;
        synchronized (BackupUtil.class) {
            if (backupRoot1 != null) return;
            BackupUtil.makeBackupRootAlways();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void makeBackupRootAlways() {
        int i;
        IOException exceptionResult = null;
        File restore = BackupUtil.checkRestore();
        for (i = 0; !BackupUtil.checkBackupRoot(i) && i < 100; ++i) {
            File localBackupRoot;
            File backupInitialStage = null;
            File localDeletionStage = null;
            File flagFile = null;
            String randomName = FileUtil.getRandomFileNameBase64();
            backupInitialStage = new File(root, Integer.toString(i) + "." + randomName + ".newdir" + System.currentTimeMillis());
            if (!backupInitialStage.mkdir() || !(localDeletionStage = new File(backupInitialStage, deletionStageName)).mkdir()) continue;
            String name = Integer.toString(i) + "." + FileUtil.getRandomFileNameBase64() + ".flag" + System.currentTimeMillis();
            flagFile = new File(localDeletionStage, name);
            boolean created = false;
            try {
                created = flagFile.createNewFile();
            }
            catch (IOException e) {
                exceptionResult = e;
                continue;
            }
            finally {
                if (created) {
                    flagFile.delete();
                }
            }
            if (created && backupInitialStage.renameTo(localBackupRoot = new File(root, "backup"))) continue;
        }
        if (i >= 100) {
            throw new RuntimeException("Backup root creation failed!", exceptionResult);
        }
        if (restore != null) {
            File reservation = null;
            boolean created = false;
            try {
                reservation = BackupUtil.findReservation(restore, false);
                BackupReservation br = BackupUtil.loadReservation(reservation);
                if (br.getAcquireOnRelease()) {
                    BackupUtil.acquireBackupReservation(br.getLabel(), (int)br.getReservationTimeout(), br.getAcquireOnRelease());
                }
                String keyName = "restored-" + reservation.getName() + ".txt";
                File keyFile = new File(backupRoot1, keyName);
                created = keyFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Backup root creation failed!", e);
            }
            if (!created) {
                throw new RuntimeException("Backup root creation failed!");
            }
        }
    }

    private static File checkRestore() {
        try {
            File restoreOrBackup = BackupUtil.locateRestoreOrBackup();
            if (restoreOrBackup == null) {
                return null;
            }
            if (restoreOrBackup.getName().equals("backup")) {
                return null;
            }
            return restoreOrBackup;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static File acquireBackupReservation(String label, int reservationTimeout, boolean acquireOnRelease) throws IOException {
        return BackupUtil.acquireBackupReservation(label, reservationTimeout, acquireOnRelease, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File acquireBackupReservation(String label, int reservationTimeout, boolean acquireOnRelease, boolean releasedPrev) throws IOException {
        File existingReservation = null;
        File newReservation = null;
        existingReservation = BackupUtil.findReservationAndCleanup();
        if (existingReservation == null && deletionStage.exists()) {
            existingReservation = deletionStage;
        }
        long cTime = System.currentTimeMillis() + (long)reservationTimeout;
        Properties props = new Properties();
        props.put("label", label);
        props.put("startTime", Long.toString(cTime));
        props.put("reservationTimeout", Long.toString(reservationTimeout));
        props.put("acquireOnRelease", Boolean.toString(acquireOnRelease));
        props.put("previousReservation", existingReservation.getName());
        props.put("releasedPreviousReservation", Boolean.toString(releasedPrev));
        String name = FileUtil.getRandomFileNameBase64();
        String propsName = "pR" + name + ".xml";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(existingReservation, propsName));
            props.storeToXML((OutputStream)fos, "Properties for backup reservation " + propsName, "UTF-8");
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        newReservation = new File(BackupUtil.getBackupRoot1(), "bR" + name);
        BackupUtil.renameFile(existingReservation, newReservation);
        return newReservation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File releaseReservation() throws IOException {
        File result = BackupUtil.findReservation();
        if (result != null) {
            String propsFileName = null;
            String name = result.getName();
            boolean acquireOnRelease = false;
            int timeOut = 0;
            String label = "";
            if (name.startsWith("backupReservation-")) {
                String[] pieces = name.split("-");
                if (name.endsWith("-rolling")) {
                    label = pieces[1];
                    acquireOnRelease = true;
                    if (pieces.length > 3) {
                        try {
                            timeOut = Integer.parseInt(pieces[3]) / 60000;
                        }
                        catch (NumberFormatException e) {}
                    }
                }
            } else {
                Properties props = new Properties();
                FileInputStream fis = null;
                try {
                    propsFileName = "pR" + name.substring(2) + ".xml";
                    File in = new File(result, propsFileName);
                    fis = new FileInputStream(in);
                    props.loadFromXML(fis);
                }
                finally {
                    fis.close();
                }
                acquireOnRelease = Boolean.parseBoolean(props.getProperty("acquireOnRelease", "false"));
                if (acquireOnRelease) {
                    label = props.getProperty("label", "");
                    try {
                        timeOut = Integer.parseInt(props.getProperty("reservationTimeout", "0"));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (acquireOnRelease) {
                result = BackupUtil.acquireBackupReservation(label, timeOut, acquireOnRelease, true);
            } else {
                if (deletionStage == null) {
                    deletionStage = new File(result.getParentFile(), deletionStageName);
                }
                BackupUtil.hardTargetRename(result, deletionStage);
                if (propsFileName != null) {
                    File file = new File(deletionStage, propsFileName);
                    file.delete();
                }
            }
        }
        return result;
    }

    static void hardTargetRename(File existingReservation, File newReservation) throws IOException {
        if (!BackupUtil.renameFile(existingReservation, newReservation)) {
            throw new IOException("Hard target rename failed: " + existingReservation.getAbsolutePath() + " to " + newReservation.getAbsolutePath());
        }
    }

    static boolean renameFile(File existingReservation, File newReservation) {
        for (int i = 0; i < 100; ++i) {
            File localNewReservation;
            if (!existingReservation.renameTo(newReservation) || !BackupUtil.hardTargetExists(localNewReservation = new File(newReservation.getAbsolutePath()), i)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hardTargetExists(File localNewReservation, int retry) {
        if (!localNewReservation.exists()) {
            return false;
        }
        if (!localNewReservation.isDirectory()) {
            return true;
        }
        File flagFile = null;
        String name = Integer.toString(retry) + "." + FileUtil.getRandomFileNameBase64() + ".flag" + System.currentTimeMillis();
        flagFile = new File(localNewReservation, name);
        boolean created = false;
        try {
            created = flagFile.createNewFile();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (created) {
                flagFile.delete();
            }
        }
        return created;
    }

    static File findReservation() {
        try {
            return BackupUtil.findReservation(true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File findReservationAndCleanup() throws IOException {
        return BackupUtil.findReservation(false);
    }

    static File findReservation(boolean safe) throws IOException {
        return BackupUtil.findReservation(BackupUtil.getBackupRoot1(), safe);
    }

    static File findReservation(File localBackupRoot, boolean safe) throws IOException {
        String target1 = "backupReservation-";
        String target2 = "bR";
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return (name.startsWith("backupReservation-") || name.startsWith("bR")) && new File(dir, name).isDirectory();
            }
        };
        File[] list = FileCollector.listFiles(localBackupRoot, filter);
        if (list == null) {
            return null;
        }
        if (list.length > 0) {
            if (list.length > 1) {
                Comparator c = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        File f1 = (File)o1;
                        File f2 = (File)o2;
                        long delta = f1.lastModified() - f2.lastModified();
                        if (delta < 0L) {
                            return -1;
                        }
                        if (delta == 0L) {
                            return 0;
                        }
                        return 1;
                    }
                };
                Arrays.sort(list, c);
                String name = FileUtil.getRandomFileNameBase64() + ".reservations" + System.currentTimeMillis();
                File dest = new File(list[0], name);
                if (!dest.mkdir() && !safe) {
                    throw new IOException("Failed to make directory: " + dest.getAbsolutePath());
                }
                IOException caught = null;
                for (int i = 1; i < list.length && list[0].exists(); ++i) {
                    File iDest = new File(dest, list[i].getName());
                    try {
                        BackupUtil.hardTargetRename(list[i], iDest);
                        continue;
                    }
                    catch (IOException e) {
                        if (caught != null) continue;
                        caught = e;
                    }
                }
                if (caught != null && !safe) {
                    throw caught;
                }
            }
            return list[0];
        }
        return null;
    }

    public boolean hardTargetExistsWithRetries(File f) {
        for (int i = 0; i < 100; ++i) {
            if (!BackupUtil.hardTargetExists(BackupUtil.getBackupRoot1(), i)) continue;
            return true;
        }
        return false;
    }

    private static boolean updateQueueDest() {
        File reservation;
        File parent = reservation = BackupUtil.findReservation();
        if (reservation == null) {
            parent = deletionStage;
        }
        return BackupUtil.makeNewQueueDest(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean makeNewQueueDest(File queueParent) {
        boolean created;
        block19: {
            String randomName = FileUtil.getRandomFileNameBase64();
            String name = deletionPrefix + randomName;
            created = false;
            File localQueueDest = new File(queueParent, name);
            File marker = new File(localQueueDest, "!!" + localQueueDest.getName() + ".txt");
            try {
                created = localQueueDest.mkdir();
                if (!created) break block19;
                FileWriter fw = null;
                try {
                    fw = new FileWriter(marker);
                    fw.write(queueParent.getName());
                }
                catch (IOException e) {
                    created = false;
                }
                finally {
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException e) {
                            created = false;
                        }
                    }
                    if (!created) {
                        marker.delete();
                    }
                }
                try {
                    queueDest = localQueueDest.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            finally {
                if (queueDest == null) {
                    marker.delete();
                    localQueueDest.delete();
                    created = false;
                }
            }
        }
        return created;
    }

    public static BackupReservation loadReservation(File reservation) throws IOException {
        return BackupUtil.loadReservationFile(reservation, reservation.getName());
    }

    public static BackupReservation loadReservationFile(File reservation, String name) throws IOException {
        String reservationName = null;
        if (name.startsWith("bR")) {
            reservationName = name;
            name = "pR" + name.substring(2) + ".xml";
        } else {
            if (name.startsWith("backupReservation-")) {
                return BackupUtil.loadReservationFromFileName(name);
            }
            reservationName = "bR" + name.substring(2, name.length() - 4);
        }
        File f = new File(reservation, name);
        if (!f.exists()) {
            return null;
        }
        PropertiesInvocationHandler h = new PropertiesInvocationHandler(reservationName, f, defaultBackupReservationValues);
        return (BackupReservation)Proxy.newProxyInstance(BackupReservation.class.getClassLoader(), new Class[]{BackupReservation.class}, (InvocationHandler)h);
    }

    private static BackupReservation loadReservationFromFileName(String name) {
        if (!name.startsWith("backupReservation-")) {
            return null;
        }
        Properties props = new Properties();
        String[] pieces = name.split("-");
        if (pieces.length > 1) {
            props.setProperty("label", pieces[1]);
        }
        if (pieces.length > 2) {
            props.setProperty("startTime", pieces[2]);
        }
        if (pieces.length > 3) {
            props.setProperty("reservationTimeout", pieces[3]);
        }
        if (pieces.length > 4) {
            props.setProperty("acquireOnRelease", pieces[4].equals("rolling") ? "true" : "false");
        }
        props.setProperty("id", name);
        PropertiesInvocationHandler h = new PropertiesInvocationHandler(props, defaultBackupReservationValues);
        return (BackupReservation)Proxy.newProxyInstance(BackupReservation.class.getClassLoader(), new Class[]{BackupReservation.class}, (InvocationHandler)h);
    }

    public static Iterator listDeletionQueue() throws IOException {
        if (deletionStage != null && deletionStage.exists()) {
            return BackupUtil.listDeletionQueue(deletionStage);
        }
        File reservation = BackupUtil.findReservation();
        if (reservation == null) {
            return emptyIterator;
        }
        BackupReservation br = BackupUtil.loadReservation(reservation);
        if (!br.getAcquireOnRelease() && br.getReservationTimeout() > 0L && br.getStartTime() + br.getReservationTimeout() * 60000L < System.currentTimeMillis()) {
            BackupUtil.releaseReservation();
            if (deletionStage != null && deletionStage.exists()) {
                return BackupUtil.listDeletionQueue(deletionStage);
            }
            return emptyIterator;
        }
        return BackupUtil.listDeletionQueue(reservation);
    }

    private static void processReservation(File reservation, Set toDelete, Set propertyFileToDelete) throws IOException {
        BackupReservation br = BackupUtil.loadReservation(reservation);
        int generationDistance = 0;
        boolean released = false;
        String leafReservation = null;
        while (br != null) {
            String previousReservation;
            if (generationDistance > 1) {
                toDelete.add(br.getId());
                leafReservation = br.getId();
            }
            if (released = br.getReleasedPreviousReservation()) {
                ++generationDistance;
            }
            if ((previousReservation = br.getPreviousReservation()) != null && previousReservation.startsWith("bR")) {
                br = BackupUtil.loadReservationFile(br.getDirectory(), br.getPreviousReservation());
                continue;
            }
            if (generationDistance > 1) {
                toDelete.add(deletionStageName);
            }
            br = null;
        }
        if (leafReservation != null) {
            propertyFileToDelete.add(leafReservation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator listDeletionQueue(File dir) throws IOException {
        if (dir == null) {
            return emptyIterator;
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("!!bR") || name.startsWith(BackupUtil.deletionPrefix) || name.startsWith("backupReservation-") || name.startsWith("bR") || name.startsWith("pR");
            }
        };
        HashSet toDelete = null;
        HashSet propertyFileToDelete = null;
        ArrayList result = new ArrayList();
        ArrayList<File> recurse = new ArrayList<File>();
        recurse.add(dir);
        while (recurse.size() > 0) {
            File[] list;
            File r = (File)recurse.remove(0);
            String name = r.getName();
            if (!name.startsWith("backupReservation-") && !name.startsWith("bR") && !name.equals(deletionStageName)) continue;
            if (r.getName().startsWith("bR") || r.getName().startsWith("backupReservation-")) {
                toDelete = new HashSet();
                propertyFileToDelete = new HashSet();
                BackupUtil.processReservation(r, toDelete, propertyFileToDelete);
            }
            if ((list = FileCollector.listFiles(r, filter)) == null) continue;
            for (int i = 0; i < list.length; ++i) {
                File f = list[i];
                if (f.getName().startsWith("pR") && toDelete == null) {
                    f.delete();
                }
                if (!f.isDirectory()) continue;
                if (f.getName().startsWith(deletionPrefix)) {
                    if (toDelete == null) {
                        BackupUtil.addQueueItems(f, result);
                        continue;
                    }
                    String marker = "!!" + f.getName() + ".txt";
                    FileReader fr = null;
                    BufferedReader br = null;
                    String reservation = null;
                    File markerFile = new File(f, marker);
                    if (markerFile.exists()) {
                        try {
                            fr = new FileReader(markerFile);
                            br = new BufferedReader(fr);
                            reservation = br.readLine();
                        }
                        catch (FileNotFoundException fnfe) {
                        }
                        finally {
                            if (br != null) {
                                br.close();
                            }
                        }
                    }
                    if (reservation == null || !toDelete.contains(reservation)) continue;
                    propertyFileToDelete.remove(reservation);
                    BackupUtil.addQueueItems(f, result);
                    continue;
                }
                if (!f.getName().startsWith("backupReservation-") && !f.getName().startsWith("bR")) continue;
                recurse.add(f);
            }
        }
        if (propertyFileToDelete != null) {
            for (String target : propertyFileToDelete) {
                if (!target.startsWith("bR") || target.indexOf(47) >= 0 || target.indexOf(92) >= 0) continue;
                File targetFile = new File(dir, "pR" + target.substring(2) + ".xml");
                targetFile.delete();
            }
        }
        return result.iterator();
    }

    private static void addQueueItems(File d, ArrayList result) {
        File[] items = FileCollector.listFiles(d);
        if (items == null) {
            return;
        }
        File reservationId = null;
        boolean added = false;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getName().startsWith("!!dQ")) {
                reservationId = items[i];
                continue;
            }
            added = true;
            result.add(items[i]);
        }
        if (!added) {
            if (reservationId != null) {
                result.add(reservationId);
            }
            result.add(d);
        }
    }

    public static void queueDeletion(String in) throws IOException {
        IOException thrown = null;
        boolean created = false;
        String name = BackupUtil.encodePath(in);
        for (int i = 0; !created && i < 100; ++i) {
            block6: {
                File queuedDelete = new File(queueDest, name);
                try {
                    created = queuedDelete.createNewFile();
                }
                catch (IOException e) {
                    if (thrown != null) break block6;
                    thrown = e;
                }
            }
            if (created || i % 10 != 0 || !BackupUtil.updateQueueDest()) continue;
            filePerDirCount = 0;
        }
        if (!created) {
            if (thrown != null) {
                throw thrown;
            }
            throw new IOException("Failed to queue file for deletion: " + name);
        }
        if (++filePerDirCount >= 500) {
            filePerDirCount = BackupUtil.makeNewQueueDest(queueDest.getParentFile()) ? 0 : 250;
        }
    }

    public static String encodePath(String in) {
        StringBuffer buf = new StringBuffer();
        char pending = '\u0000';
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c < ' ' || c > '\u007f' || encode[c]) {
                buf.append('!');
                buf.append(Integer.toHexString(c));
                pending = '_';
                continue;
            }
            if (pending != '\u0000') {
                buf.append(pending);
                pending = '\u0000';
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static void executeQueuedDeletions(File dir) {
        if (dir == null) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(BackupUtil.deletionPrefix) || name.startsWith(BackupUtil.trashPrefix) || name.startsWith("backupReservation-") || name.startsWith("bR");
            }
        };
        ArrayList<File> recurse = new ArrayList<File>();
        recurse.add(dir);
        while (recurse.size() > 0) {
            File[] list;
            File r = (File)recurse.remove(0);
            String name = r.getName();
            if (!name.startsWith("backupReservation-") && !name.equals(deletionStageName) && !name.startsWith("bR") || (list = FileCollector.listFiles(r, filter)) == null) continue;
            for (int i = 0; i < list.length; ++i) {
                File f = list[i];
                if (!f.isDirectory()) continue;
                if (f.getName().startsWith(trashPrefix)) {
                    BackupUtil.processTrash(f);
                }
                if (f.getName().startsWith(deletionPrefix) || !f.getName().startsWith("backupReservation-") && !f.getName().startsWith("bR")) continue;
                recurse.add(f);
            }
        }
    }

    private static void processTrash(File in) {
        String tName = in.getName();
        if (!tName.startsWith(trashPrefix)) {
            return;
        }
        Stack<File> recurse = new Stack<File>();
        recurse.push(in);
        while (recurse.size() > 0) {
            File r = (File)recurse.pop();
            File[] list = FileCollector.listFiles(r);
            if (list == null || list.length < 1) {
                r.delete();
                continue;
            }
            recurse.push(r);
            for (int i = 0; i < list.length; ++i) {
                File f = list[i];
                f.delete();
                if (!f.exists() || !f.isDirectory()) continue;
                recurse.push(f);
            }
        }
    }

    private static void processDeletionQueue(File f) {
        if (!f.getName().startsWith(deletionPrefix)) {
            return;
        }
        File[] list = FileCollector.listFiles(f);
        if (list == null) {
            return;
        }
        int deleted = 0;
        for (int i = 0; i < list.length; ++i) {
            File target;
            if (!list[i].getName().startsWith("docm") || !(target = BackupUtil.decodePath(list[i].getName())).delete() || !list[i].delete()) continue;
            ++deleted;
        }
        if (deleted >= list.length) {
            f.delete();
        }
    }

    public static File decodePath(String name) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            int c = name.charAt(i);
            int n = i;
            if (c == 33) {
                int j = name.indexOf(33, i + 1);
                int k = name.indexOf(95, i + 1);
                n = k > 0 && (j < 0 || k < j) ? (j = k) : j - 1;
                if (j < 0) {
                    n = j = name.length();
                }
                try {
                    c = (char)Integer.parseInt(name.substring(i + 1, j), 16);
                }
                catch (NumberFormatException nfe) {
                    c = 63;
                }
                i = n;
            }
            buf.append((char)c);
        }
        String filePath = buf.toString();
        if (filePath.indexOf(File.separator + ".." + File.separator) != -1) {
            return null;
        }
        if (filePath.startsWith(".." + File.separator)) {
            return null;
        }
        File out = new File(root, filePath);
        try {
            String backupRootCanonPath = root.getCanonicalPath();
            String outCanonPath = out.getCanonicalPath();
            if (!backupRootCanonPath.endsWith(File.separator)) {
                backupRootCanonPath = backupRootCanonPath + File.separator;
            }
            if (!outCanonPath.startsWith(backupRootCanonPath)) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return out;
    }

    public static boolean isReservationDone() {
        return true;
    }

    public static String[] isFileCollectionInProgress() {
        String[] myFile = new String[]{"node1_collectionInProgress", "node2_collectionInProgress"};
        return myFile;
    }

    public static void createReservationFile() {
    }

    public static void removeReservationFile() {
    }

    public static boolean isBackupRoot(File rootDir) {
        if (rootDir == null || root == null) {
            return false;
        }
        return rootDir.equals(root);
    }

    public static File getDeletionDest() {
        return deletionDest;
    }

    static File getBackupRoot1() {
        BackupUtil.makeBackupRoot();
        return backupRoot1;
    }

    static {
        for (int i = 0; i < 127; ++i) {
            BackupUtil.encode[i] = true;
            if (!Character.isDigit(i) && !Character.isLetter(i)) continue;
            BackupUtil.encode[i] = false;
        }
        BackupUtil.encode[46] = false;
        BackupUtil.encode[45] = false;
    }

    public static class DefaultBackupReservationValues
    implements BackupReservation {
        public boolean getAcquireOnRelease() {
            return false;
        }

        public String getLabel() {
            return "";
        }

        public String getPreviousReservation() {
            return "";
        }

        public boolean getReleasedPreviousReservation() {
            return false;
        }

        public long getReservationTimeout() {
            return 0L;
        }

        public long getStartTime() {
            return 0L;
        }

        public File getDirectory() {
            return null;
        }

        public String getId() {
            return null;
        }
    }

    public static class EmptyIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

