/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.url;

import com.adobe.url.AuthenticatedURLConnection;
import com.adobe.url.UrlDataProvider;
import com.adobe.url.UrlDataProviderHome;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Util {
    static Hashtable _urlDataProviderHomeCache = new Hashtable();
    public static UrlDataProviderHome _repositoryHome = null;
    public static UrlDataProviderHome _xappstoreHome = null;

    public static InputStream openUrlStream(String url, byte[] context, StringBuffer contentType) throws IOException {
        InputStream is;
        int colon = url.indexOf(":");
        if (colon == -1) {
            throw new MalformedURLException("The URL doesn't have a proper protocol separator");
        }
        String protocol = url.substring(0, colon);
        UrlDataProviderHome home = (UrlDataProviderHome)_urlDataProviderHomeCache.get(protocol);
        if (home == null) {
            if (protocol.equals("repository") && _repositoryHome != null) {
                home = _repositoryHome;
            } else if (protocol.equals("xappstore") && _xappstoreHome != null) {
                home = _xappstoreHome;
            } else {
                try {
                    InitialContext ic = new InitialContext();
                    home = (UrlDataProviderHome)ic.lookup("com/adobe/local/" + protocol + "UrlDataProvider");
                }
                catch (NamingException e) {
                    try {
                        InitialContext ic = new InitialContext();
                        home = (UrlDataProviderHome)ic.lookup("local:ejb/com/adobe/local/" + protocol + "UrlDataProvider");
                    }
                    catch (NamingException e2) {
                        // empty catch block
                    }
                }
            }
            if (home != null) {
                _urlDataProviderHomeCache.put(protocol, home);
            }
        }
        if (home != null) {
            UrlDataProvider urlBean;
            try {
                urlBean = home.create();
            }
            catch (CreateException e) {
                throw new IOException("Failed to create an UrlDataProvider EJB instance: " + e.toString());
            }
            InputStream is2 = urlBean.getInputStream(url, context, contentType);
            if (is2 == null) {
                throw new IOException("UrlDataProvider should not return NULL. URL: " + url + ". urlBean: " + urlBean.getClass().getName());
            }
            return is2;
        }
        URL netUrl = new URL(url);
        URLConnection urlCon = netUrl.openConnection();
        if (context != null && urlCon instanceof AuthenticatedURLConnection) {
            ((AuthenticatedURLConnection)((Object)urlCon)).setInvocationContext(context);
        }
        if ((is = urlCon.getInputStream()) == null) {
            throw new IOException("URLConnection should not return NULL. URL: " + url + ". urlCon: " + urlCon.getClass().getName());
        }
        contentType.append(urlCon.getContentType());
        return is;
    }
}

