/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.statistics;

import com.adobe.statistics.LowPassFilter;

public class TimeWeigtedLowPassFilter
extends LowPassFilter {
    long sampleTime = 0L;
    double currentSample = 0.0;

    public TimeWeigtedLowPassFilter(double timeConstant, double mean) {
        super(timeConstant);
        this.accumulate(mean);
    }

    public TimeWeigtedLowPassFilter(double timeConstant) {
        super(timeConstant);
    }

    public void accumulate(double sample) {
        if (this.initialized) {
            long now = System.currentTimeMillis();
            long time = now - this.sampleTime;
            this.accumulate(this.currentSample, time);
            this.sampleTime = now;
            this.currentSample = sample;
        } else {
            this.sampleTime = System.currentTimeMillis();
            this.mean = sample;
            this.initialized = true;
        }
    }

    public double getMean() {
        long time = System.currentTimeMillis() - this.sampleTime;
        return this.mean + (1.0 - Math.pow(this.coefficient, time)) * (this.currentSample - this.mean);
    }
}

