/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.statistics;

import com.adobe.statistics.MeanAndVariance;

public class TimeWeightedMeanAndVariance
extends MeanAndVariance {
    long sampleTime = 0L;
    double pendingSample = 0.0;

    public TimeWeightedMeanAndVariance() {
    }

    public TimeWeightedMeanAndVariance(TimeWeightedMeanAndVariance orig) {
        super(orig);
        this.sampleTime = orig.sampleTime;
        this.pendingSample = orig.pendingSample;
    }

    public void reset() {
        super.reset();
        this.sampleTime = 0L;
        this.pendingSample = 0.0;
    }

    public final void accumulate(double sample) {
        long currTime = System.currentTimeMillis();
        if (this.sampleTime != 0L) {
            this.accumulate(this.pendingSample, currTime - this.sampleTime);
        }
        this.pendingSample = sample;
        this.sampleTime = currTime;
    }

    public double getMean() {
        double weight = System.currentTimeMillis() - this.sampleTime;
        if (weight > 0.0) {
            double q = this.pendingSample - this.mean;
            double tempW = this.sumWeights + weight;
            double r = q * weight / tempW;
            return this.mean + r;
        }
        return this.mean;
    }

    public double getVariance() {
        double weight = System.currentTimeMillis() - this.sampleTime;
        if (weight > 0.0) {
            double q = this.pendingSample - this.mean;
            double tempW = this.sumWeights + weight;
            double r = q * weight / tempW;
            return (this.sumWeightedSquares + r * this.sumWeights * q) / tempW;
        }
        if (this.sumWeights <= 0.0) {
            return 0.0;
        }
        return this.sumWeightedSquares / this.sumWeights;
    }
}

