/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.statistics;

import com.adobe.statistics.Accumulator;

public class MeanAndVariance
implements Accumulator,
Cloneable {
    double mean = 0.0;
    double sumWeightedSquares = 0.0;
    double sumWeights = 0.0;

    public MeanAndVariance() {
    }

    public MeanAndVariance(MeanAndVariance orig) {
        this.mean = orig.mean;
        this.sumWeightedSquares = orig.sumWeightedSquares;
        this.sumWeights = orig.sumWeights;
    }

    public void reset() {
        this.mean = 0.0;
        this.sumWeightedSquares = 0.0;
        this.sumWeights = 0.0;
    }

    public void accumulate(double sample, double weight) {
        this.westsAlgorithmStep(sample, weight);
    }

    public void accumulate(double sample) {
        this.accumulate(sample, 1.0);
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        if (this.sumWeights <= 0.0) {
            return 0.0;
        }
        return this.sumWeightedSquares / this.sumWeights;
    }

    public final double getStdDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        return "mean=" + this.getMean() + ", var=" + this.getVariance() + ", stddev=" + this.getStdDeviation();
    }

    protected final void westsAlgorithmStep(double sample, double weight) {
        if (weight <= 0.0) {
            return;
        }
        double q = sample - this.mean;
        double tempW = this.sumWeights + weight;
        double r = q * weight / tempW;
        this.mean += r;
        this.sumWeightedSquares += r * this.sumWeights * q;
        this.sumWeights = tempW;
    }
}

