/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.statistics;

import com.adobe.statistics.Accumulator;

public class LowPassFilter
implements Accumulator,
Cloneable {
    private static final double minusOneOverLogHalf = -1.0 / Math.log(0.5);
    double timeConstant;
    double coefficient;
    double mean = 0.0;
    boolean initialized = false;

    public LowPassFilter(double timeConstant, double mean) {
        this.setTimeConstant(timeConstant);
        this.accumulate(mean);
    }

    public LowPassFilter(double timeConstant) {
        this.setTimeConstant(timeConstant);
    }

    public void reset() {
        this.mean = 0.0;
        this.initialized = false;
    }

    public void accumulate(double sample) {
        if (this.initialized) {
            this.mean += (1.0 - this.coefficient) * (sample - this.mean);
        } else {
            this.mean = sample;
            this.initialized = true;
        }
    }

    public void accumulate(double sample, double weight) {
        if (this.initialized) {
            this.mean += (1.0 - Math.pow(this.coefficient, weight)) * (sample - this.mean);
        } else {
            this.mean = sample;
            this.initialized = true;
        }
    }

    public void fixupLastSample(double sampleIncrement, double weight) {
        this.mean += (1.0 - Math.pow(this.coefficient, weight)) * sampleIncrement;
    }

    public double getMean() {
        return this.mean;
    }

    public void setTimeConstant(double timeConstant) {
        this.timeConstant = timeConstant;
        this.coefficient = LowPassFilter.timeConstantToCoefficient(timeConstant);
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public static double timeConstantToCoefficient(double timeConstant) {
        return Math.exp(-1.0 / timeConstant);
    }

    public static double coefficientToTimeConstant(double coefficient) {
        return -1.0 / Math.log(coefficient);
    }

    public static double halfLifeToTimeConstant(double halflife) {
        return halflife * minusOneOverLogHalf;
    }
}

