/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx.statistics;

import com.adobe.jmx.DynamicImpl;
import com.adobe.jmx.JmxPortability;
import com.adobe.jmx.Notifier;
import com.adobe.jmx.statistics.ManagedObjectAttributes;
import com.adobe.jmx.statistics.Statistic;
import com.adobe.jmx.statistics.StatisticsHost;
import com.adobe.jmx.statistics.StatisticsProviderPeer;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class StatisticsProvider
extends DynamicImpl
implements StatisticsHost,
MBeanRegistration,
ManagedObjectAttributes {
    private ObjectName objectName;
    private boolean registerStatMBeans = false;
    final HashMap statsBeans = new HashMap();
    Notifier countThresholdNotifier;
    Notifier rangeThresholdNotifier;
    private final StatisticsProviderPeer peer = StatisticsProviderPeer.factory.create(this);

    public StatisticsProvider(String name) {
        this(JmxPortability.makeName(JmxPortability.ADOBE_STATS_PROVIDER_TYPE, name));
    }

    public StatisticsProvider(ObjectName parent, String type, String name) {
        this(JmxPortability.makeName(parent, type, name));
    }

    public StatisticsProvider(ObjectName objectName) {
        super((Object)null, null);
        this.objectName = objectName;
        this.addReflectionTarget(this, ManagedObjectAttributes.class);
        this.addReflectionTarget(this.peer);
    }

    public StatisticsProvider getStatisticsProvider() {
        return this;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void initObjectName(ObjectName objectName) {
        if (this.objectName != null) {
            throw new IllegalStateException("Cannot re-init ObjectName");
        }
        this.objectName = objectName;
    }

    public void register() {
        JmxPortability.registerMBeanIfPossible(this, this.getObjectName());
    }

    public void register(ObjectName objectName) {
        JmxPortability.registerMBeanIfPossible(this, objectName);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        if (name != null) {
            this.objectName = name;
        }
        return this.objectName;
    }

    public synchronized void postRegister(Boolean success) {
        for (Map.Entry entry : this.statsBeans.entrySet()) {
            Statistic stat = (Statistic)entry.getValue();
            JmxPortability.registerMBeanIfPossible(stat, stat.getObjectName());
        }
        this.registerStatMBeans = true;
    }

    public synchronized void preDeregister() throws Exception {
        this.registerStatMBeans = false;
        Exception firstException = null;
        for (Map.Entry entry : this.statsBeans.entrySet()) {
            Statistic stat = (Statistic)entry.getValue();
            MBeanServer mbeanServer = JmxPortability.mBeanServer;
            try {
                mbeanServer.unregisterMBean(stat.getObjectName());
            }
            catch (Exception e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void postDeregister() {
    }

    synchronized void addStat(Statistic stat) {
        String name = stat.getName();
        this.statsBeans.put(name, stat);
        if (this.registerStatMBeans) {
            JmxPortability.registerMBeanIfPossible(stat, stat.getObjectName());
        }
    }

    public synchronized Statistic findStatistic(String name) {
        return (Statistic)this.statsBeans.get(name);
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return !this.statsBeans.isEmpty();
    }

    public boolean isEventProvider() {
        return this.hasNotifiers();
    }
}

