/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx;

import com.adobe.logging.AdobeLogger;
import com.adobe.util.Peer;
import com.adobe.util.UtilMsg;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public abstract class JmxPortability {
    private static final AdobeLogger logger = AdobeLogger.getAdobeLogger(JmxPortability.class);
    private static final JmxPortability impl = (JmxPortability)Peer.getSingleton(JmxPortability.class);
    public static final MBeanServer mBeanServer = impl.initMBeanServer();
    public static final String TYPE_STRING = impl.initTypeString();
    public static final String NAME_STRING = impl.initNameString();
    public static final String ADOBE_SERVICE_TYPE = impl.initServiceType();
    public static final String ADOBE_STATS_PROVIDER_TYPE = impl.initStatsProviderType();
    public static final String ADOBE_STAT_TYPE = impl.initStatType();
    public static final String ADOBE_DOMAIN_NAME = impl.initDomainName(mBeanServer);

    public static ObjectName makeName(String type, String name) {
        return impl.doMakeName(type, name);
    }

    public static ObjectName makeName(ObjectName parent, String type, String name) {
        return impl.doMakeName(parent, type, name);
    }

    public static boolean isAdobeObjectName(ObjectName name) {
        return impl.doIsAdobeObjectName(name.getDomain(), name.getKeyPropertyList());
    }

    public static Collection getAdobeObjectNames() {
        return impl.doGetAdobeObjectNames();
    }

    public static ObjectInstance registerMBeanIfPossible(Object bean, ObjectName objectName) {
        return impl.doRegisterMBeanIfPossible(bean, objectName);
    }

    ObjectName doMakeName(ObjectName parent, String type, String name) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (parent == null) {
            return this.doMakeName(type, name);
        }
        String domain = parent.getDomain();
        h.putAll(parent.getKeyPropertyList());
        String t1 = (String)h.remove(TYPE_STRING);
        String n1 = (String)h.remove(NAME_STRING);
        if (t1 != null && n1 != null) {
            h.put(t1, n1);
        }
        h.put(TYPE_STRING, type);
        h.put(NAME_STRING, name);
        try {
            ObjectName objectName = new ObjectName(domain, h);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException e2 = new IllegalArgumentException();
            e2.initCause(e);
            throw e2;
        }
    }

    ObjectName doMakeName(String type, String name) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put(TYPE_STRING, type);
        h.put(NAME_STRING, name);
        try {
            ObjectName objectName = new ObjectName(ADOBE_DOMAIN_NAME, h);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException e2 = new IllegalArgumentException();
            e2.initCause(e);
            throw e2;
        }
    }

    ObjectInstance doRegisterMBeanIfPossible(Object bean, ObjectName objectName) {
        MBeanServer mbeanServer = mBeanServer;
        try {
            try {
                return mbeanServer.registerMBean(bean, objectName);
            }
            catch (InstanceAlreadyExistsException e) {
                if (objectName == null) {
                    throw e;
                }
                mbeanServer.unregisterMBean(objectName);
                return mbeanServer.registerMBean(bean, objectName);
            }
        }
        catch (RuntimeException e) {
            logger.log((Throwable)e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"registering MBean");
            throw e;
        }
        catch (Exception e) {
            logger.log((Throwable)e, UtilMsg.AN_UNEXPECTED_EXCEPTION_WHILE, (Object)"registering MBean");
            IllegalStateException r = new IllegalStateException();
            r.initCause(e);
            throw r;
        }
    }

    boolean doIsAdobeObjectName(String domain, Hashtable props) {
        if (!ADOBE_DOMAIN_NAME.equals(domain)) {
            return false;
        }
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            if (!this.isAdobeProp((String)e.nextElement())) continue;
            return true;
        }
        if (props.get(ADOBE_STAT_TYPE) != null) {
            return true;
        }
        if (props.get(ADOBE_SERVICE_TYPE) != null) {
            return true;
        }
        return this.isAdobeProp((String)props.get(TYPE_STRING));
    }

    boolean isAdobeProp(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("Adobe")) {
            return true;
        }
        if (name.startsWith("adobe")) {
            return true;
        }
        if (ADOBE_STAT_TYPE.equals(name)) {
            return true;
        }
        if (ADOBE_SERVICE_TYPE.equals(name)) {
            return true;
        }
        return ADOBE_STATS_PROVIDER_TYPE.equals(name);
    }

    Collection doGetAdobeObjectNames() {
        Set<ObjectName> names = mBeanServer.queryNames(null, null);
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            ObjectName name = (ObjectName)iter.next();
            if (JmxPortability.isAdobeObjectName(name)) continue;
            iter.remove();
        }
        return names;
    }

    String initTypeString() {
        return "j2eeType";
    }

    String initNameString() {
        return "name";
    }

    String initServiceType() {
        return "AdobeService";
    }

    String initStatType() {
        return "AdobeStat";
    }

    String initStatsProviderType() {
        return "AdobeStatisticsProvider";
    }

    String initDomainName(MBeanServer mBeanServer) {
        return mBeanServer.getDefaultDomain();
    }

    abstract MBeanServer initMBeanServer();
}

