/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jmx;

import com.adobe.jmx.NotifierType;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;

public class DynamicImpl
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private final Map attributes = new HashMap();
    private final HashMap operations = new HashMap();
    static final MBeanFeatureInfoComparator mbeanFeatureInfoComparator = new MBeanFeatureInfoComparator();
    private ArrayList notifiers = new ArrayList();
    private long seq = 0L;
    private final Object metadataObject;
    private MBeanInfo mbeanInfo = null;
    private ResourceBundle localizationResources;
    private static ResourceBundle sharedLocalizationResources;
    private static final Object[] noArgs;
    private static final Class[] noArgTypes;
    private static final MBeanAttributeInfo[] emptyMBeanAttributeInfoArray;
    private static final MBeanOperationInfo[] emptyMBeanOperationInfoArray;
    private static final MBeanConstructorInfo[] emptyMBeanConstructorInfoArray;
    private static final MBeanNotificationInfo[] emptyMBeanNotificationInfoArray;
    private static final String[] emptyStringArray;

    protected DynamicImpl() {
        this.metadataObject = this;
        this.addReflectionTarget(this);
        this.initLocalizationResources();
    }

    protected DynamicImpl(Class managementInterface) {
        this.metadataObject = this;
        if (managementInterface != null) {
            this.addReflectionTarget(this, managementInterface);
        }
        this.initLocalizationResources();
    }

    public DynamicImpl(Object managed) {
        if (managed != null) {
            this.addReflectionTarget(managed);
            this.metadataObject = managed;
        } else {
            this.metadataObject = this;
        }
        this.initLocalizationResources();
    }

    public DynamicImpl(Object managed, Class managementInterface) {
        if (managed != null) {
            this.metadataObject = managed;
            if (managementInterface != null) {
                this.addReflectionTarget(managed, managementInterface);
            }
        } else {
            this.metadataObject = this;
        }
        this.initLocalizationResources();
    }

    public void addReflectionTarget(Object target, Class mgmtInterface) {
        if ((mgmtInterface.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("management interface must be public: " + mgmtInterface.getName());
        }
        if (!mgmtInterface.isInstance(target)) {
            throw new IllegalArgumentException("target " + target.getClass().getName() + " must implement management interface " + mgmtInterface.getName());
        }
        Method[] methods = mgmtInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.addReflectionMethod(target, methods[i]);
        }
    }

    public void addReflectionTarget(Object target) {
        Class mgmtIf = DynamicImpl.deduceManagementInterface(target);
        if (mgmtIf == null) {
            throw new IllegalArgumentException("Object does not implement management interface " + target.getClass().getName() + "MBean");
        }
        this.addReflectionTarget(target, mgmtIf);
    }

    protected static Class deduceManagementInterface(Object target) {
        Class<?> mgmtIf;
        String className = target.getClass().getName();
        ClassLoader loader = target.getClass().getClassLoader();
        if (target instanceof SayManagementInterface) {
            return ((SayManagementInterface)target).sayManagementInterface();
        }
        try {
            mgmtIf = loader.loadClass(className + "MBean");
            if (mgmtIf.isInstance(target)) {
                return mgmtIf;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            mgmtIf = loader.loadClass(className + "Mgmt");
            if (mgmtIf.isInstance(target)) {
                return mgmtIf;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public synchronized void addAttr(String name, Attr attr) {
        this.attributes.put(name, attr);
        this.mbeanInfo = null;
    }

    private synchronized void addReflectionAttr(Object target, String name, Method getter, Method setter) {
        Attr tmp = (Attr)this.attributes.get(name);
        ReflectionAttr attr = null;
        if (tmp instanceof ReflectionAttr) {
            attr = (ReflectionAttr)tmp;
            if (attr.target != target) {
                attr = null;
            }
        }
        if (attr == null) {
            attr = new ReflectionAttr(target, name);
            this.attributes.put(name, attr);
        }
        if (getter != null) {
            attr.getter = getter;
        }
        if (setter != null) {
            attr.setter = setter;
        }
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Attr a = (Attr)this.attributes.get(name);
        if (a == null && name.length() > 0 && Character.isLowerCase(name.charAt(0))) {
            String name2 = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            a = (Attr)this.attributes.get(name2);
        }
        if (a == null) {
            throw new AttributeNotFoundException(name + " not readable");
        }
        return a.getAttrValue();
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attr.getName();
        Object value = attr.getValue();
        Attr a = (Attr)this.attributes.get(name);
        if (a == null) {
            throw new AttributeNotFoundException(name + " not writable");
        }
        a.setAttrValue(value);
    }

    public AttributeList getAttributes(String[] attrs) {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                Attribute attr = new Attribute(attrs[i], this.getAttribute(attrs[i]));
                attributeList.add(attr);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public synchronized AttributeList setAttributes(AttributeList attrs) {
        AttributeList ret = new AttributeList();
        for (Attribute attr : attrs) {
            try {
                this.setAttribute(attr);
                ret.add(attr);
            }
            catch (Exception e) {}
        }
        return ret;
    }

    public Object invoke(String methodName, Object[] args, String[] argTypeNames) throws MBeanException, ReflectionException {
        if (args.length != argTypeNames.length) {
            throw new IllegalArgumentException("args length != types length");
        }
        StringBuffer buf = new StringBuffer(methodName);
        buf.append('(');
        for (int i = 0; i < argTypeNames.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(argTypeNames[i]);
        }
        buf.append(')');
        String fullMethodName = buf.toString();
        Operation op = (Operation)this.operations.get(fullMethodName);
        if (op != null) {
            return op.invoke(args);
        }
        try {
            if (args.length == 0) {
                if (methodName.startsWith("get")) {
                    return this.getAttribute(methodName.substring(3));
                }
                if (methodName.startsWith("is")) {
                    return this.getAttribute(methodName.substring(2));
                }
            }
            if (args.length == 1 && methodName.startsWith("set")) {
                Attribute a = new Attribute(methodName.substring(3), args[0]);
                this.setAttribute(a);
                return null;
            }
        }
        catch (AttributeNotFoundException e) {
        }
        catch (InvalidAttributeValueException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof Exception)) {
                cause = e;
            }
            throw new MBeanException((Exception)cause, "bad attribute value: " + fullMethodName);
        }
        throw new MBeanException(null, "no method: " + fullMethodName);
    }

    public synchronized void addOperation(String name, Operation operation) {
        this.operations.put(name, operation);
    }

    public void addReflectionMethod(Object target, Method method) {
        String methodName = method.getName();
        if (!method.getDeclaringClass().isInstance(target)) {
            throw new IllegalArgumentException("target " + target.getClass().getName() + " must implement method " + method);
        }
        int nParams = method.getParameterTypes().length;
        if (nParams == 0 && methodName.startsWith("get")) {
            this.addReflectionAttr(target, methodName.substring(3), method, null);
        } else if (nParams == 0 && methodName.startsWith("is")) {
            this.addReflectionAttr(target, methodName.substring(2), method, null);
        } else if (nParams == 1 && methodName.startsWith("set")) {
            this.addReflectionAttr(target, methodName.substring(3), null, method);
        } else {
            this.addReflectionOperation(target, method);
        }
    }

    private void addReflectionOperation(Object target, Method method) {
        this.addOperation(method.getName() + DynamicImpl.signatureStr(method.getParameterTypes()), new ReflectionOperation(target, method));
    }

    synchronized void addNotifier(NotifierType notifier) {
        this.mbeanInfo = null;
        this.notifiers.add(notifier);
    }

    public synchronized boolean hasNotifiers() {
        return !this.notifiers.isEmpty();
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = new MBeanInfo(this.getMBeanClassName(), this.getMBeanDescription(), this.getAttributeInfo(), this.getConstructorInfo(), this.getOperationInfo(), this.getNotificationInfo());
        }
        return this.mbeanInfo;
    }

    protected MBeanAttributeInfo[] getAttributeInfo() {
        HashSet<MBeanAttributeInfo> attrs = new HashSet<MBeanAttributeInfo>();
        for (Map.Entry entry : this.attributes.entrySet()) {
            Attr attr = (Attr)entry.getValue();
            attrs.add(attr.getMBeanAttributeInfo());
        }
        MBeanAttributeInfo[] res = attrs.toArray(emptyMBeanAttributeInfoArray);
        Arrays.sort(res, mbeanFeatureInfoComparator);
        return res;
    }

    protected MBeanConstructorInfo[] getConstructorInfo() {
        Constructor<?>[] ctors = this.getClass().getConstructors();
        ArrayList<MBeanConstructorInfo> cons = new ArrayList<MBeanConstructorInfo>();
        for (int i = 0; i < ctors.length; ++i) {
            if ((ctors[i].getModifiers() & 1) == 0) continue;
            cons.add(new MBeanConstructorInfo(this.getConstructorDescription(ctors[i]), ctors[i]));
        }
        MBeanConstructorInfo[] res = cons.toArray(emptyMBeanConstructorInfoArray);
        Arrays.sort(res, mbeanFeatureInfoComparator);
        return res;
    }

    protected MBeanOperationInfo[] getOperationInfo() {
        HashSet<MBeanOperationInfo> ops = new HashSet<MBeanOperationInfo>();
        for (Map.Entry entry : this.operations.entrySet()) {
            Operation op = (Operation)entry.getValue();
            ops.add(op.getMBeanOperationInfo());
        }
        MBeanOperationInfo[] res = ops.toArray(emptyMBeanOperationInfoArray);
        Arrays.sort(res, mbeanFeatureInfoComparator);
        return res;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        HashMap<Class, ArrayList<String>> notifiersByClass = new HashMap<Class, ArrayList<String>>();
        for (NotifierType notifier : this.notifiers) {
            ArrayList<String> types = (ArrayList<String>)notifiersByClass.get(notifier.getNotificationClass());
            if (types == null) {
                types = new ArrayList<String>();
                notifiersByClass.put(notifier.getNotificationClass(), types);
            }
            types.add(notifier.getNotificationType());
        }
        HashSet<MBeanNotificationInfo> notifications = new HashSet<MBeanNotificationInfo>();
        for (Map.Entry entry : notifiersByClass.entrySet()) {
            Class cls = (Class)entry.getKey();
            String name = cls.getName();
            ArrayList types = (ArrayList)entry.getValue();
            String notifyDesc = this.getNotificationDescription(cls);
            MBeanNotificationInfo info = new MBeanNotificationInfo(types.toArray(emptyStringArray), name, notifyDesc);
            notifications.add(info);
        }
        MBeanNotificationInfo[] res = notifications.toArray(emptyMBeanNotificationInfoArray);
        Arrays.sort(res, mbeanFeatureInfoComparator);
        return res;
    }

    protected String getMBeanClassName() {
        return this.metadataObject.getClass().getName();
    }

    protected String getMBeanDescription() {
        return this.getDescription(this.metadataObject.getClass(), null);
    }

    private String getAttributeDescription(String attrName, Method setter, Method getter) {
        Class<?> declaringClass = null;
        if (setter != null) {
            declaringClass = setter.getDeclaringClass();
        } else if (getter != null) {
            declaringClass = getter.getDeclaringClass();
        }
        return this.getAttributeDescription(attrName, declaringClass);
    }

    protected String getAttributeDescription(String attrName, Class defnClass) {
        return this.getDescription(defnClass, attrName);
    }

    public String getAttributeDescription(String attrName) {
        return this.getDescription(null, attrName);
    }

    protected String getMethodDescription(Method method) {
        String desc = this.getDescription(method.getDeclaringClass(), method.getName() + DynamicImpl.signatureStr(method.getParameterTypes()));
        if (desc != null && desc.length() != 0) {
            return desc;
        }
        desc = this.getDescription(method.getDeclaringClass(), method.getName() + "(...)");
        return desc;
    }

    protected int getMethodImpact(Method method) {
        String impact = this.getDescription(method.getDeclaringClass(), method.getName() + DynamicImpl.signatureStr(method.getParameterTypes()) + ".impact");
        if (impact == null || impact.length() == 0) {
            impact = this.getDescription(method.getDeclaringClass(), method.getName() + "(...).impact");
        }
        if ("action".equalsIgnoreCase(impact)) {
            return 1;
        }
        if ("action_info".equalsIgnoreCase(impact)) {
            return 2;
        }
        if ("info".equalsIgnoreCase(impact)) {
            return 0;
        }
        return 3;
    }

    protected String getConstructorDescription(Constructor ctor) {
        String name = ctor.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        String desc = this.getDescription(ctor.getDeclaringClass(), name + DynamicImpl.signatureStr(ctor.getParameterTypes()));
        if (desc != null && desc.length() != 0) {
            return desc;
        }
        desc = this.getDescription(ctor.getDeclaringClass(), name + "(...)");
        return desc;
    }

    protected String getNotificationDescription(Class cls) {
        return this.getDescription(cls, cls.getName() + "!");
    }

    protected String getDescription(Class defnClass, String thingName) {
        Class<?> mgmtClass = this.metadataObject.getClass();
        String fullMgmtClassName = mgmtClass.getName();
        String mgmtClassName = fullMgmtClassName.substring(fullMgmtClassName.lastIndexOf(46) + 1);
        thingName = thingName != null ? "." + thingName : "";
        try {
            return this.localizationResources.getString(mgmtClassName + thingName);
        }
        catch (Throwable e) {
            try {
                return sharedLocalizationResources.getString(fullMgmtClassName + thingName);
            }
            catch (Throwable e2) {
                if (defnClass != null && mgmtClass != defnClass) {
                    String fullDefnClassName = defnClass.getName();
                    String defnClassName = fullDefnClassName.substring(fullDefnClassName.lastIndexOf(46) + 1);
                    try {
                        return this.localizationResources.getString(defnClassName + thingName);
                    }
                    catch (Throwable e3) {
                        try {
                            return sharedLocalizationResources.getString(fullDefnClassName + thingName);
                        }
                        catch (Throwable e22) {
                            // empty catch block
                        }
                    }
                }
                return "";
            }
        }
    }

    public synchronized void setLocalizationResources(ResourceBundle res) {
        this.localizationResources = res;
    }

    public static synchronized void setSharedLocalizationResources(ResourceBundle res) {
        sharedLocalizationResources = res;
    }

    private void initLocalizationResources() {
        String name = this.metadataObject.getClass().getName();
        try {
            this.localizationResources = ResourceBundle.getBundle(name, Locale.getDefault(), this.metadataObject.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            try {
                name = name.substring(name.lastIndexOf(46) + 1);
                this.localizationResources = ResourceBundle.getBundle(name, Locale.getDefault(), this.metadataObject.getClass().getClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public synchronized void printLocalizationTemplates(PrintStream out) {
        String full = this.metadataObject.getClass().getName();
        String fullPath = full.replace('.', '/');
        ResourceBundle old = this.localizationResources;
        ResourceBundle oldShared = sharedLocalizationResources;
        LocalizationTemplateBundle nullBundle = new LocalizationTemplateBundle(null, null, "", true);
        out.println();
        out.println("##########");
        out.println("# Localization template for \"" + this.getClass().getName() + "\" MBean.");
        out.println("#   Save in MBean-specific localization resource " + fullPath + ".properties");
        out.println();
        out.println("# By MBean implementation:");
        String pref = full.substring(full.lastIndexOf(46) + 1);
        this.localizationResources = new LocalizationTemplateBundle(out, old, pref, true);
        sharedLocalizationResources = nullBundle;
        this.mbeanInfo = null;
        this.getMBeanInfo();
        out.println();
        out.println("# By MBean interface definition:");
        this.localizationResources = new LocalizationTemplateBundle(out, old, pref, false);
        this.mbeanInfo = null;
        this.getMBeanInfo();
        out.println();
        out.println("##########");
        out.println("# Localization template for \"" + this.getClass().getName() + "\" MBean.");
        out.println("#   Add to common MBean localization resource MBeanLocalization.properties");
        out.println();
        out.println("# By MBean implementation:");
        this.localizationResources = nullBundle;
        sharedLocalizationResources = new LocalizationTemplateBundle(out, oldShared, full, true);
        this.mbeanInfo = null;
        this.getMBeanInfo();
        out.println();
        out.println("# By MBean interface definition:");
        sharedLocalizationResources = new LocalizationTemplateBundle(out, oldShared, full, false);
        this.mbeanInfo = null;
        this.getMBeanInfo();
        sharedLocalizationResources = oldShared;
        this.localizationResources = old;
        this.mbeanInfo = null;
    }

    static String signatureStr(Class[] paramTypes) {
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(paramTypes[i].getName());
        }
        buf.append(')');
        return buf.toString();
    }

    final synchronized long getNextEventSeqNumber() {
        return this.seq++;
    }

    static {
        try {
            sharedLocalizationResources = ResourceBundle.getBundle("MBeanLocalization");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        noArgs = new Object[0];
        noArgTypes = new Class[0];
        emptyMBeanAttributeInfoArray = new MBeanAttributeInfo[0];
        emptyMBeanOperationInfoArray = new MBeanOperationInfo[0];
        emptyMBeanConstructorInfoArray = new MBeanConstructorInfo[0];
        emptyMBeanNotificationInfoArray = new MBeanNotificationInfo[0];
        emptyStringArray = new String[0];
    }

    static class MBeanFeatureInfoComparator
    implements Comparator {
        MBeanFeatureInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            MBeanFeatureInfo f1 = (MBeanFeatureInfo)o1;
            MBeanFeatureInfo f2 = (MBeanFeatureInfo)o2;
            return f1.getName().compareTo(f2.getName());
        }
    }

    private static class LocalizationTemplateBundle
    extends ResourceBundle {
        final ResourceBundle redir;
        final PrintStream out;
        final String prefix;
        final boolean prefYes;

        LocalizationTemplateBundle(PrintStream out, ResourceBundle redir, String prefix, boolean prefYes) {
            this.out = out;
            this.redir = redir;
            this.prefix = prefix;
            this.prefYes = prefYes;
        }

        protected Object handleGetObject(String propName) {
            if (this.out != null && propName.startsWith(this.prefix) ^ !this.prefYes) {
                String val = "";
                try {
                    if (this.redir != null) {
                        val = this.redir.getString(propName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.out.println(propName + ": " + val);
            }
            throw new MissingResourceException("", "", "");
        }

        public Enumeration getKeys() {
            return null;
        }
    }

    private class ReflectionOperation
    implements Operation {
        final Method method;
        final Object target;

        ReflectionOperation(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        public MBeanOperationInfo getMBeanOperationInfo() {
            return new MBeanOperationInfo(DynamicImpl.this.getMethodDescription(this.method), this.method);
        }

        public Object invoke(Object[] args) throws MBeanException {
            try {
                return this.method.invoke(this.target, args);
            }
            catch (Exception e) {
                throw new MBeanException(e, "invoking" + this.method.getName());
            }
        }
    }

    static interface Operation {
        public MBeanOperationInfo getMBeanOperationInfo();

        public Object invoke(Object[] var1) throws MBeanException;
    }

    private class ReflectionAttr
    implements Attr {
        String name;
        Method getter;
        Method setter;
        Object target;

        ReflectionAttr(Object target, String name) {
            this.name = name;
            this.target = target;
        }

        public Object getAttrValue() throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (this.getter == null) {
                throw new AttributeNotFoundException(this.name + " not readable");
            }
            try {
                return this.getter.invoke(this.target, noArgs);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e, "getting " + this.name);
            }
            catch (Exception e) {
                throw new MBeanException(e, "getting " + this.name);
            }
        }

        public void setAttrValue(Object value) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (this.setter == null) {
                throw new AttributeNotFoundException(this.name + " not writable");
            }
            try {
                this.setter.invoke(this.target, value);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e, "setting " + this.name);
            }
            catch (IllegalAccessException e) {
                throw new MBeanException(e, "setting " + this.name);
            }
        }

        public MBeanAttributeInfo getMBeanAttributeInfo() {
            try {
                String attrDesc = DynamicImpl.this.getAttributeDescription(this.name, this.getter, this.setter);
                MBeanAttributeInfo info = new MBeanAttributeInfo(this.name, attrDesc, this.getter, this.setter);
                return info;
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("Bad methods " + this.getter + " " + this.setter, e);
            }
        }
    }

    public static interface Attr {
        public MBeanAttributeInfo getMBeanAttributeInfo();

        public Object getAttrValue() throws AttributeNotFoundException, MBeanException, ReflectionException;

        public void setAttrValue(Object var1) throws AttributeNotFoundException, MBeanException, InvalidAttributeValueException, ReflectionException;
    }

    public static interface SayManagementInterface {
        public Class sayManagementInterface();
    }
}

