/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework.localization;

import com.adobe.util.Utilities;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class ZString {
    public static final String JAVA_PARAM_PATTERN = "{.}";
    public static final String LEGACY_PARAM_PATTERN = "^.";
    private final String mPlaceHolder = ".";
    private final int firstParmID = 0;
    private final int secondParmID = 1;
    private final int thirdParmID = 2;
    private final int forthParmID = 3;
    private Locale mLocale = Locale.getDefault();
    private String mBaseName = "AppResource";
    private String mInEncoding = "UTF-16";
    private String mOutEncoding = "UTF-16";
    private String mParamPattern = "^.";
    private ClassLoader mClassLoader = Utilities.getClassLoader();

    public static String getKey(String inKey) {
        int equalSign = inKey.indexOf(61);
        return equalSign > 0 ? inKey.substring(0, equalSign) : inKey;
    }

    public static String getDefault(String inKey) {
        int equalSign = inKey.indexOf(61);
        return equalSign > 0 ? inKey.substring(equalSign + 1) : inKey;
    }

    public static String buildKey(String inKey, String inDefault) {
        StringBuffer result = new StringBuffer(inKey);
        if (ZString.getDefault(inKey).equals("")) {
            result.append("=").append(inDefault);
        }
        return result.toString();
    }

    public ZString() {
    }

    public ZString(String inBundleName) {
        this.mBaseName = inBundleName;
    }

    public ZString(String inBundleName, Locale inLocale) {
        this.mLocale = inLocale;
        this.mBaseName = inBundleName;
    }

    public ZString(String inBundleName, ClassLoader inClassLoader) {
        this.mClassLoader = inClassLoader;
        this.mBaseName = inBundleName;
    }

    public ZString(String inBundleName, Locale inLocale, ClassLoader inClassLoader) {
        this.mLocale = inLocale;
        this.mBaseName = inBundleName;
        this.mClassLoader = inClassLoader;
    }

    public final String getValue(String inZkey, Locale inLocale) {
        String retValue;
        try {
            retValue = this.escapeUnicode(this.loadString(inZkey, inLocale));
        }
        catch (Throwable tr) {
            retValue = ZString.getDefault(inZkey);
        }
        return retValue;
    }

    public final String getValue(String inZkey) {
        String retValue;
        try {
            retValue = this.escapeUnicode(this.loadString(inZkey, this.mLocale));
        }
        catch (Throwable tr) {
            retValue = ZString.getDefault(inZkey);
        }
        return retValue;
    }

    public final String getValue(String inZkey, String param0) {
        return this.getValue(inZkey, param0, null, null, null);
    }

    public final String getValue(String inZkey, String param0, String param1) {
        return this.getValue(inZkey, param0, param1, null, null);
    }

    public final String getValue(String inZkey, String param0, String param1, String param2) {
        return this.getValue(inZkey, param0, param1, param2, null);
    }

    public final String getValue(String inZkey, String param0, String param1, String param2, String param3) {
        String stringValue = this.loadString(inZkey, this.mLocale);
        if (stringValue != null) {
            if (param0 != null) {
                stringValue = this.setParameter(stringValue, 0, param0);
            }
            if (param1 != null) {
                stringValue = this.setParameter(stringValue, 1, param1);
            }
            if (param2 != null) {
                stringValue = this.setParameter(stringValue, 2, param2);
            }
            if (param3 != null) {
                stringValue = this.setParameter(stringValue, 3, param3);
            }
        }
        try {
            stringValue = this.escapeUnicode(new String(stringValue.getBytes(), this.mOutEncoding));
        }
        catch (Throwable tr) {
            stringValue = "";
        }
        return stringValue;
    }

    public final String getValue(String inZkey, String[] args) {
        String stringValue = this.loadString(inZkey, this.mLocale);
        if (stringValue != null && args != null) {
            for (int i = 0; i < args.length; ++i) {
                stringValue = this.setParameter(stringValue, i, args[i]);
            }
        }
        try {
            stringValue = this.escapeUnicode(stringValue);
        }
        catch (UnsupportedEncodingException ex) {
            stringValue = "encoding?";
        }
        return stringValue;
    }

    public final String getValue(String inZkey, String[] args, Locale inLocale) {
        String stringValue = this.loadString(inZkey, inLocale);
        if (stringValue != null && args != null) {
            for (int i = 0; i < args.length; ++i) {
                stringValue = this.setParameter(stringValue, i, args[i]);
            }
        }
        try {
            stringValue = this.escapeUnicode(stringValue);
        }
        catch (UnsupportedEncodingException ex) {
            stringValue = "encoding?";
        }
        return stringValue;
    }

    public final String formatDate(Date inDate) {
        DateFormat aFormatter = DateFormat.getDateTimeInstance(3, 0, this.getLocale());
        return aFormatter.format(inDate);
    }

    public final String formatDate(Date inDate, String inFormat) {
        return this.formatDate(inDate, inFormat, this.getLocale());
    }

    public final String formatDate(Date inDate, String inFormat, Locale inLocale) {
        if (inDate == null || inFormat == null || inLocale == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(inFormat, inLocale);
        return formatter.format(inDate);
    }

    public final String formatCurrency(float inCurrency) {
        return NumberFormat.getCurrencyInstance(this.getLocale()).format(Double.valueOf(String.valueOf(inCurrency)));
    }

    public final String formatCurrency(float inCurrency, Locale inLocale) {
        return NumberFormat.getCurrencyInstance(inLocale).format(Double.valueOf(String.valueOf(inCurrency)));
    }

    public final String formatNumber(double inNumber) {
        return this.formatNumber(inNumber, this.getLocale());
    }

    public final String formatNumber(double inNumber, Locale inLocale) {
        return NumberFormat.getInstance(inLocale).format(Double.valueOf(String.valueOf(inNumber)));
    }

    public final String formatNumber(double inNumber, Locale inLocale, String inPattern) {
        return new DecimalFormat(inPattern, new DecimalFormatSymbols(inLocale)).format(Double.valueOf(String.valueOf(inNumber)));
    }

    public final boolean exists(String inZkey) {
        boolean present = true;
        try {
            String stringValue = ResourceBundle.getBundle(this.mBaseName, this.mLocale, this.mClassLoader).getString(ZString.getKey(inZkey));
        }
        catch (Throwable tr) {
            present = false;
        }
        return present;
    }

    public final void setLocale(Locale inLocale) {
        this.mLocale = inLocale;
    }

    public final Locale getLocale() {
        return this.mLocale;
    }

    public final String getInputEncoding() {
        return this.mInEncoding;
    }

    public final void setInputEncoding(String inSourceEncoding) {
        this.mInEncoding = inSourceEncoding;
    }

    public final void setClassLoader(ClassLoader inClassLoader) {
        this.mClassLoader = inClassLoader;
    }

    public final void setBundleName(String inBundle) {
        this.mBaseName = inBundle;
    }

    public final ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public final String getOutputEncoding() {
        return this.mOutEncoding;
    }

    public final void setOutputEncoding(String inOutEncoding) {
        this.mOutEncoding = inOutEncoding;
    }

    public final void setParamPattern(String inPattern) {
        this.mParamPattern = inPattern;
    }

    private String loadString(String inZkey, Locale inLocale) {
        String stringValue;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.mBaseName, inLocale, this.mClassLoader);
            String origValue = bundle.getString(ZString.getKey(inZkey));
            stringValue = new String(origValue.getBytes(this.mInEncoding), this.mInEncoding);
        }
        catch (Throwable tr) {
            stringValue = ZString.getDefault(inZkey);
        }
        return stringValue;
    }

    private String setParameter(String inSource, int inParamNumber, String inValue) {
        String inParam = this.buildParamString(inParamNumber);
        return Utilities.replaceAll(inSource, inParam, inValue);
    }

    private String buildParamString(int inValue) {
        int pos = this.mParamPattern.indexOf(".");
        return this.mParamPattern.substring(0, pos) + Integer.toString(inValue) + this.mParamPattern.substring(pos + 1);
    }

    private String escapeUnicode(String inString) throws UnsupportedEncodingException {
        String result = "";
        String input = new String(inString.getBytes(this.mInEncoding), this.mInEncoding);
        result = new String(input.getBytes(this.mOutEncoding), this.mOutEncoding);
        return result;
    }
}

