/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import com.adobe.framework.AdobeJarSupport;
import com.adobe.util.Utilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

public class JarOutputSupport
extends AdobeJarSupport {
    private JarOutputStream jos = null;
    private File jarFile = null;
    private File baseFile = null;
    private boolean keepBase = false;

    public JarOutputSupport(File inFile) {
        super(false);
        this.jarFile = inFile;
    }

    public void archive(String inFile, String inVersion, boolean keepBase) throws IOException {
        this.archive(inFile, inVersion, keepBase, new Manifest());
    }

    public void archive(String inFile, String inVersion, boolean keepBase, Manifest inManifest) throws IOException {
        this.baseFile = new File(inFile);
        this.keepBase = keepBase;
        this.setManifest(inManifest);
        if (this.getVersion() == null) {
            this.setVersion(inVersion);
        }
        this.setTimeStamp(new Date().getTime());
        this.setAttribute("Manifest-Version", "1.0");
        this.jos = new JarOutputStream((OutputStream)new FileOutputStream(this.jarFile), this.getManifest());
        this.jos.setMethod(8);
        this.writeEntries(inFile);
        this.jos.flush();
        this.jos.close();
    }

    public void close() throws IOException {
    }

    private void writeEntries(String inEntry) throws IOException {
        File srcFile = new File(inEntry);
        if (srcFile.isDirectory()) {
            String[] files = srcFile.list();
            for (int i = 0; i < files.length; ++i) {
                String filename = srcFile.getPath() + File.separator + files[i];
                this.writeEntries(filename);
            }
        } else {
            String normalizedEntry = Utilities.nomalizeFilePath(inEntry, "\\", "/");
            if (!normalizedEntry.endsWith("/MANIFEST.MF")) {
                int count;
                String path;
                byte[] data = new byte[2048];
                FileInputStream fis = new FileInputStream(srcFile);
                BufferedInputStream input = new BufferedInputStream(fis, 2048);
                ZipEntry entry = null;
                entry = this.keepBase ? new ZipEntry(normalizedEntry) : ((path = this.baseFile.getPath()).equals(inEntry) ? new ZipEntry("") : new ZipEntry(normalizedEntry.substring(path.length() + 1)));
                CRC32 crc = new CRC32();
                crc.update(0);
                entry.setCrc(crc.getValue());
                entry.setTime(new Date().getTime());
                this.jos.putNextEntry(entry);
                while ((count = input.read(data, 0, 2048)) != -1) {
                    this.jos.write(data, 0, count);
                }
                input.close();
                this.jos.closeEntry();
            }
        }
    }
}

