/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import com.adobe.framework.Base64;

public abstract class DataStore {
    public static final String GLOBAL_NS = "adobe.global";
    private final String delimiter = "_";

    public void put(String inNameSpace, String inKey, String inValue) {
        this.putData(inNameSpace + "_" + inKey, inValue);
    }

    public void put(String inNameSpace, String inKey, int inValue) {
        this.putData(inNameSpace + "_" + inKey, Integer.toString(inValue));
    }

    public void put(String inNameSpace, String inKey, long inValue) {
        this.putData(inNameSpace + "_" + inKey, Long.toString(inValue));
    }

    public void put(String inNameSpace, String inKey, float inValue) {
        this.putData(inNameSpace + "_" + inKey, Float.toString(inValue));
    }

    public void put(String inNameSpace, String inKey, double inValue) {
        this.putData(inNameSpace + "_" + inKey, Double.toString(inValue));
    }

    public void put(String inNameSpace, String inKey, boolean inValue) {
        this.putData(inNameSpace + "_" + inKey, Boolean.toString(inValue));
    }

    public void put(String inNameSpace, String inKey, byte[] inValue) {
        String newValue = Base64.encodeBytes(inValue);
        this.putData(inNameSpace + "_" + inKey, newValue);
    }

    public String getString(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        String result = value.toString();
        return result;
    }

    public int getInt(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        int result = Integer.parseInt(value.toString());
        return result;
    }

    public long getLong(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        long result = Long.parseLong(value.toString());
        return result;
    }

    public float getFloat(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        float result = Float.parseFloat(value.toString());
        return result;
    }

    public double getDouble(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        double result = Double.parseDouble(value.toString());
        return result;
    }

    public boolean getBoolean(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        boolean result = Boolean.valueOf(value.toString());
        return result;
    }

    public byte[] getByteArray(String inNameSpace, String inKey) throws Exception {
        Object value = this.getData(inNameSpace + "_" + inKey);
        byte[] result = Base64.decode(value.toString());
        return result;
    }

    protected abstract void putData(String var1, Object var2);

    protected abstract Object getData(String var1) throws Exception;
}

