/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import com.adobe.framework.DataStore;
import com.adobe.framework.XMLUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.dom4j.io.DOMReader;
import org.dom4j.io.XMLWriter;

public class Configuration
extends DataStore {
    private static final String CONFIG_ROOT = "configuration";
    private static final String RESOURCE_PREFIX = "com/adobe/config/";
    private static final String RESOURCE_SUFFIX = "-init.properties";
    private static final String FILE_PREFIX = "adobe" + File.separatorChar + "persist" + File.separatorChar;
    private static final String FILE_SUFFIX = "-config.xml";
    private static Hashtable data = new Hashtable();
    private String baseName = "";
    private static String persistDir = System.getProperty("user.home");

    public Configuration(String inBaseName) {
        this.baseName = inBaseName;
    }

    public void setDirectory(String inDirectory) {
        persistDir = inDirectory;
    }

    public void load(String inNameSpace, boolean inUseDefaults) throws Exception {
        boolean fileFound = false;
        FileInputStream stream = null;
        File persistFile = new File(persistDir, this.fileName(this.baseName));
        if (inUseDefaults) {
            data = new Hashtable();
        }
        if (!inUseDefaults && persistFile.exists() && persistFile.canRead()) {
            stream = new FileInputStream(persistFile);
            fileFound = true;
            data.putAll(XMLUtilities.xmlToMap(stream));
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(this.resourceName(this.baseName));
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    this.put(inNameSpace, key, props.getProperty(key, ""));
                }
                this.save();
            }
        }
    }

    public void save() throws Exception {
        File persistFile = new File(persistDir, this.fileName(this.baseName));
        String path = persistFile.getCanonicalPath();
        int pos = path.lastIndexOf(47);
        if (pos == -1) {
            pos = path.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            String dirs = path.substring(0, pos);
            File destDir = new File(dirs);
            destDir.mkdirs();
        }
        persistFile.createNewFile();
        FileOutputStream xmlResource = new FileOutputStream(persistFile);
        XMLWriter out = new XMLWriter((OutputStream)xmlResource);
        DOMReader reader = new DOMReader();
        out.write(reader.read(XMLUtilities.mapToXML(CONFIG_ROOT, data)));
        ((OutputStream)xmlResource).close();
    }

    protected void putData(String inKey, Object inValue) {
        data.put(inKey, inValue);
    }

    protected Object getData(String inKey) throws Exception {
        if (!data.containsKey(inKey)) {
            throw new Exception("No value for key = " + inKey);
        }
        Object value = data.get(inKey);
        return value;
    }

    private String resourceName(String inBaseName) {
        return RESOURCE_PREFIX + inBaseName + RESOURCE_SUFFIX;
    }

    private String fileName(String inBaseName) {
        return FILE_PREFIX + inBaseName + FILE_SUFFIX;
    }
}

