/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.framework;

import com.adobe.util.Utilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;

public abstract class AdobeJarSupport {
    protected boolean timeCheck = false;
    protected Manifest manifest = null;
    protected final int BUFFER_SIZE = 2048;
    protected final String manifestName = "META-INF/MANIFEST.MF";
    protected final String manifestVer = "1.0";
    public static final String VERSION_ATTR = "AdobeVersion";
    public static final String TIMESTAMP_ATTR = "AdobeTimeStamp";
    public static final String MANIFEST_ATTR = "Manifest-Version";

    public AdobeJarSupport(boolean inCheckTimeStamp) {
        this.timeCheck = inCheckTimeStamp;
    }

    public String getVersion() {
        return this.manifest.getMainAttributes().getValue(VERSION_ATTR);
    }

    public void setVersion(String inVersion) {
        this.manifest.getMainAttributes().putValue(VERSION_ATTR, inVersion);
    }

    public long getTimeStamp() {
        String ts = this.manifest.getMainAttributes().getValue(TIMESTAMP_ATTR);
        long result = 0L;
        if (ts != null) {
            result = Long.parseLong(ts);
        }
        return result;
    }

    public void setTimeStamp(long inTimeStamp) {
        this.manifest.getMainAttributes().putValue(TIMESTAMP_ATTR, Long.toString(inTimeStamp));
    }

    public void setAttribute(String inKey, String inValue) {
        this.manifest.getMainAttributes().putValue(inKey, inValue);
    }

    public String getAttribute(String inKey) {
        return this.manifest.getMainAttributes().getValue(inKey);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest inManifest) {
        this.manifest = inManifest;
    }

    protected void unjar(File inDirectory, InputStream inJarStream, JarEntry inEntryName, boolean inPersist) throws IOException {
        this.unjar(inDirectory, inJarStream, inEntryName, inPersist, false);
    }

    protected void unjar(File inDirectory, InputStream inJarStream, JarEntry inEntryName, boolean inPersist, boolean setSharedXbit) throws IOException {
        File destFile = null;
        int pos = inEntryName.getName().lastIndexOf(47);
        if (pos == -1) {
            pos = inEntryName.getName().lastIndexOf(File.separator);
        }
        if (pos != -1) {
            String path = inEntryName.getName().substring(0, pos);
            File destDir = new File(inDirectory, path);
            destDir.mkdirs();
            destFile = new File(inDirectory, inEntryName.getName());
        } else {
            destFile = new File(inDirectory, inEntryName.getName());
        }
        if (!this.timeCheck || inEntryName.getTime() > destFile.lastModified()) {
            if (!destFile.isDirectory()) {
                if (destFile.exists() && destFile.canWrite() || destFile.createNewFile()) {
                    if (!inPersist) {
                        destFile.deleteOnExit();
                    }
                    FileOutputStream destStream = new FileOutputStream(destFile);
                    if (inJarStream != null) {
                        int count;
                        byte[] data = new byte[2048];
                        while ((count = inJarStream.read(data, 0, 2048)) != -1) {
                            destStream.write(data, 0, count);
                        }
                        destStream.flush();
                        destStream.close();
                        String destFileName = destFile.getName();
                        if (setSharedXbit && (destFileName.endsWith(".sl") || destFileName.indexOf(".sl.") != -1)) {
                            Utilities.setFileMode(destFile.getCanonicalPath(), false, true);
                        }
                    }
                } else {
                    throw new IOException("Can't unjar file '" + inEntryName.getName() + "' into directory '" + inDirectory + "'");
                }
            }
            destFile.setLastModified(inEntryName.getTime());
        }
    }

    public abstract void close() throws IOException;
}

