/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.debugging;

import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public final class ObjectTracker {
    private static transient HashMap classes = new HashMap();
    private static HashMap objects = new HashMap(1000);
    private static ReferenceQueue refQueue = new ReferenceQueue();
    private static int totalAllocations = 0;
    private static int totalDeallocations = 0;
    private static PrintStream out = System.err;
    private static long summaryIntervalMillis = 300000L;
    private static int summaryIntervalCount = 100000;
    private static Thread reaper = new ReaperThread();

    private ObjectTracker() {
    }

    public static synchronized void track(Object obj) {
        WeakReference<Object> ref;
        Class<?> cls = obj.getClass();
        ClassInfo clsInfo = (ClassInfo)classes.get(cls);
        if (clsInfo == null) {
            out.println("== Tracking class " + cls.getName());
            clsInfo = new ClassInfo();
            classes.put(cls, clsInfo);
        }
        if (objects.put(ref = new WeakReference<Object>(obj, refQueue), clsInfo) == null) {
            ++clsInfo.allocations;
            ++totalAllocations;
        }
    }

    public static synchronized void summarize() {
        out.println("======================");
        out.println("= Object references at " + new Date());
        Set keys = classes.keySet();
        for (Class cls : keys) {
            ObjectTracker.summarize(cls);
        }
        out.println("Total: " + totalAllocations + " - " + totalDeallocations + " = " + (totalAllocations - totalDeallocations));
    }

    public static synchronized void summarize(Class cls) {
        ClassInfo clsInfo = (ClassInfo)classes.get(cls);
        if (clsInfo != null) {
            out.println("Class " + cls.getName() + ": " + clsInfo.allocations + " - " + clsInfo.deallocations + " = " + (clsInfo.allocations - clsInfo.deallocations));
        }
    }

    public static void setSummaryIntervalMillis(long intervalMillis) {
        summaryIntervalMillis = intervalMillis;
    }

    public static long getSummaryIntervalMillis() {
        return summaryIntervalMillis;
    }

    public static void setSummaryIntervalCount(int count) {
        summaryIntervalCount = count;
    }

    public static int getSummaryIntervalCount() {
        return summaryIntervalCount;
    }

    private static class ReaperThread
    extends Thread {
        ReaperThread() {
            super("ObjectTracker");
            try {
                this.setDaemon(true);
                this.setPriority(10);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                int cnt = 0;
                long nextSummaryTime = System.currentTimeMillis() + summaryIntervalMillis;
                block4: while (true) {
                    long timeout;
                    if ((timeout = nextSummaryTime - System.currentTimeMillis()) <= 0L || cnt >= summaryIntervalCount) {
                        ObjectTracker.summarize();
                        timeout = summaryIntervalMillis;
                        nextSummaryTime = System.currentTimeMillis() + summaryIntervalMillis;
                        cnt = 0;
                    }
                    Reference ref = refQueue.remove(timeout);
                    while (true) {
                        if (ref == null) continue block4;
                        Class<ObjectTracker> clazz = ObjectTracker.class;
                        // MONITORENTER : com.adobe.debugging.ObjectTracker.class
                        ClassInfo clsInfo = (ClassInfo)objects.get(ref);
                        if (clsInfo != null) {
                            objects.remove(ref);
                            ++clsInfo.deallocations;
                            totalDeallocations++;
                            ++cnt;
                        }
                        // MONITOREXIT : clazz
                        ref = refQueue.poll();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                ObjectTracker.summarize();
                return;
            }
        }
    }

    private static class ClassInfo {
        int allocations = 0;
        int deallocations = 0;

        private ClassInfo() {
        }
    }
}

