/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.um.dsc.util.client;

import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.um.api.UMException;
import com.adobe.idp.um.api.infomodel.AuthResult;
import com.adobe.livecycle.usermanager.client.ManagerServiceClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class UserManagerUtilServiceClient
extends ManagerServiceClient {
    private ServiceClientFactory serviceFactory = null;
    private static final String serviceName = "UserManagerUtilService";

    public UserManagerUtilServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceFactory = serviceClientFactory;
    }

    public Map getDirectorySyncStatus(Set domainNames) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("domainNames", domainNames);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "getDirectorySyncStatus", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void scheduleSynchronization() throws UMException {
        try {
            HashMap input = new HashMap();
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "scheduleSynchronizationForAllDomains", input, true);
            InvocationResponse invocationResponse = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void scheduleSynchronization(Set domainNames) throws UMException {
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("domainNames", domainNames);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "scheduleSynchronization", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean isAPSAuditServiceEnabled() throws UMException {
        boolean returnValue = false;
        try {
            HashMap input = new HashMap();
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "isAPSAuditServiceEnabled", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Boolean)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void setAPSAuditServiceState(boolean enabled) throws UMException {
        try {
            HashMap<String, Boolean> input = new HashMap<String, Boolean>();
            input.put("enabled", new Boolean(enabled));
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "setAPSAuditServiceState", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void importPolicyServer7DomainConfig(String confingXML, Map data) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("confingXML", confingXML);
            input.put("data", data);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "importPolicyServer7DomainConfig", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public AuthResult authenticate(String username, byte[] password, Map authenticationOptions) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("username", username);
            input.put("password", password);
            input.put("authenticationOptions", authenticationOptions);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "authenticate", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(byte[] ssoToken, boolean createAssertion, Map authenticationOptions) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("ssoToken", ssoToken);
            input.put("createAssertion", new Boolean(createAssertion));
            input.put("authenticationOptions", authenticationOptions);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "authenticateWithSSOToken", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String wssecHeader, Map authenticationOptions) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("wssecHeader", wssecHeader);
            input.put("authenticationOptions", authenticationOptions);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "authenticateWithWSHeader", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(Element wssecHeaderElement, Map authenticationOptions) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("wssecHeaderElement", wssecHeaderElement);
            input.put("authenticationOptions", authenticationOptions);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "authenticateWithWSHeaderElement", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String unsignedData, String signatureValue, Map authenticationOptions) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("unsignedData", unsignedData);
            input.put("signatureValue", signatureValue);
            input.put("authenticationOptions", authenticationOptions);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "authenticateCert", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findDomains(Set domainOids) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("domainOids", domainOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest(serviceName, "findDomains", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }
}

