/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.usermanager.client;

import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.um.api.SPIRegistrationManager;
import com.adobe.idp.um.api.UMException;
import com.adobe.livecycle.usermanager.client.ManagerServiceClient;
import java.util.HashMap;

public class SPIRegistrationManagerServiceClient
extends ManagerServiceClient
implements SPIRegistrationManager {
    private ServiceClientFactory serviceFactory = null;
    private static String SPI_REGISTRATION_SERVICE = "SPIRegistrationService";

    public SPIRegistrationManagerServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceFactory = serviceClientFactory;
    }

    public void registerServiceProvider(String serviceName, int serviceProviderType) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("serviceName", serviceName);
            input.put("serviceProviderType", new Integer(serviceProviderType));
            InvocationRequest request = this.serviceFactory.createInvocationRequest(SPI_REGISTRATION_SERVICE, "registerServiceProvider", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void unregisterServiceProvider(String serviceName, int serviceProviderType) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("serviceName", serviceName);
            input.put("serviceProviderType", new Integer(serviceProviderType));
            InvocationRequest request = this.serviceFactory.createInvocationRequest(SPI_REGISTRATION_SERVICE, "unregisterServiceProvider", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void enableServiceProvider(String serviceName, int serviceProviderType) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("serviceName", serviceName);
            input.put("serviceProviderType", new Integer(serviceProviderType));
            InvocationRequest request = this.serviceFactory.createInvocationRequest(SPI_REGISTRATION_SERVICE, "startServiceProvider", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void disableServiceProvider(String serviceName, int serviceProviderType) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("serviceName", serviceName);
            input.put("serviceProviderType", new Integer(serviceProviderType));
            InvocationRequest request = this.serviceFactory.createInvocationRequest(SPI_REGISTRATION_SERVICE, "stopServiceProvider", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

