/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.usermanager.client;

import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.um.api.DirectoryManager;
import com.adobe.idp.um.api.UMException;
import com.adobe.idp.um.api.infomodel.Domain;
import com.adobe.idp.um.api.infomodel.Group;
import com.adobe.idp.um.api.infomodel.GroupMembershipSearchFilter;
import com.adobe.idp.um.api.infomodel.Principal;
import com.adobe.idp.um.api.infomodel.PrincipalReference;
import com.adobe.idp.um.api.infomodel.PrincipalSearchFilter;
import com.adobe.idp.um.api.infomodel.User;
import com.adobe.livecycle.usermanager.client.ManagerServiceClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectoryManagerServiceClient
extends ManagerServiceClient
implements DirectoryManager {
    private ServiceClientFactory serviceFactory = null;

    public DirectoryManagerServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceFactory = serviceClientFactory;
    }

    public void createDomain(Domain d) throws UMException {
        try {
            HashMap<String, Domain> input = new HashMap<String, Domain>();
            input.put("d", d);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteDomain(String domainName) throws UMException {
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("domainName", domainName);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "deleteDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void updateDomain(Domain updatedDom) throws UMException {
        try {
            HashMap<String, Domain> input = new HashMap<String, Domain>();
            input.put("updatedDom", updatedDom);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "updateDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Domain findDomain(String domainName) throws UMException {
        Domain returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("domainName", domainName);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Domain)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map getDirectorySyncStatus(Set domainNames) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("domainNames", domainNames);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "getDirectorySyncStatus", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Group getDomainAsGroup(String domainName) throws UMException {
        Group returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("domainName", domainName);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "getDomainAsGroup", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Group)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createDirectoryPrincipal(Principal principal) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, Principal> input = new HashMap<String, Principal>();
            input.put("principal", principal);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createDirectoryPrincipal", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createLocalGroup(Group localGroup) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, Group> input = new HashMap<String, Group>();
            input.put("localGroup", localGroup);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createLocalGroup", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void deleteLocalGroup(String groupOid) throws UMException {
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("groupOid", groupOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "deleteLocalGroup", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void updateLocalGroup(Group updatedGroup) throws UMException {
        try {
            HashMap<String, Group> input = new HashMap<String, Group>();
            input.put("updatedGroup", updatedGroup);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "updateLocalGroup", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String createLocalUser(User localUser, String password) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("localUser", localUser);
            input.put("password", password);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createLocalUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createLocalUser(User localUser, String hashedPassword, String salt) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("localUser", localUser);
            input.put("hashedPassword", hashedPassword);
            input.put("salt", salt);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createLocalUserWithHashPwd", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map createLocalUsers(Set userInfo) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("userInfo", userInfo);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createLocalUsers", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createLocalSystemUser(User p) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, User> input = new HashMap<String, User>();
            input.put("p", p);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "createLocalSystemUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void deleteLocalUser(String userOid) throws UMException {
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("userOid", userOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "deleteLocalUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void updateLocalUser(User updatedUser, String password) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("updatedUser", updatedUser);
            input.put("password", password);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "updateLocalUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addPrincipalToLocalGroup(String principalOid, String localGroupOid) throws UMException {
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("principalOid", principalOid);
            input.put("localGroupOid", localGroupOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "addPrincipalToLocalGroup", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void removePrincipalFromLocalGroup(String principalOid, String localGroupOid) throws UMException {
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("principalOid", principalOid);
            input.put("localGroupOid", localGroupOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "removePrincipalFromLocalGroup", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public List findDomains() throws UMException {
        List returnValue = null;
        try {
            HashMap input = new HashMap();
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findDomains", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findGroups(PrincipalSearchFilter searchFilter) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, PrincipalSearchFilter> input = new HashMap<String, PrincipalSearchFilter>();
            input.put("searchFilter", searchFilter);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findGroups", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findUsers(PrincipalSearchFilter searchFilter) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, PrincipalSearchFilter> input = new HashMap<String, PrincipalSearchFilter>();
            input.put("searchFilter", searchFilter);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findUsers", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Principal findPrincipal(String oid) throws UMException {
        Principal returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("oid", oid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalWithOid", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Principal)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public PrincipalReference findPrincipalReference(String oid) throws UMException {
        PrincipalReference returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("oid", oid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalReferenceWithOid", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (PrincipalReference)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map findPrincipalReference(List principalOids) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, List> input = new HashMap<String, List>();
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalReferencesWithOids", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Principal findPrincipal(String domainName, String canonicalName) throws UMException {
        Principal returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("domainName", domainName);
            input.put("canonicalName", canonicalName);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipal", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Principal)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public PrincipalReference findPrincipalReference(String domainName, String canonicalName) throws UMException {
        PrincipalReference returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("domainName", domainName);
            input.put("canonicalName", canonicalName);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalReference", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (PrincipalReference)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map findPrincipals(List principalOids) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, List> input = new HashMap<String, List>();
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalsWithOids", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findGroupMembers(GroupMembershipSearchFilter gsf) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, GroupMembershipSearchFilter> input = new HashMap<String, GroupMembershipSearchFilter>();
            input.put("gsf", gsf);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findGroupMembers", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findPrincipals(PrincipalSearchFilter searchFilter, List principalOids) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("searchFilter", searchFilter);
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalsWithFilterWithinList", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map findPrincipalStatus(Set principalReferences) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("principalReferences", principalReferences);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalStatus", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map findPrincipalsByEmailId(Set emailIds) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("emailIds", emailIds);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalsByEmailId", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findPrincipalReferences(PrincipalSearchFilter searchFilter, String principalType) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("searchFilter", searchFilter);
            input.put("principalType", principalType);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalReferencesWithType", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findPrincipalReferences(PrincipalSearchFilter searchFilter) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, PrincipalSearchFilter> input = new HashMap<String, PrincipalSearchFilter>();
            input.put("searchFilter", searchFilter);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalReferencesWithFilter", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findPrincipals(PrincipalSearchFilter searchFilter, String principalType) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("searchFilter", searchFilter);
            input.put("principalType", principalType);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalsWithType", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findPrincipals(PrincipalSearchFilter searchFilter) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, PrincipalSearchFilter> input = new HashMap<String, PrincipalSearchFilter>();
            input.put("searchFilter", searchFilter);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipalsWithFilter", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map findPrincipals(Set principalReferences) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Set> input = new HashMap<String, Set>();
            input.put("principalReferences", principalReferences);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "findPrincipals", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void updateLocalUser(User updatedUser, String oldPassword, String newPassword) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("updatedUser", updatedUser);
            input.put("oldPassword", oldPassword);
            input.put("newPassword", newPassword);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "updateLocalUserChgPwd", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getBusinessCalendarKeyforUser(String oid) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("oid", oid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "getBusinessCalendarKeyforUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List getAllBusinessCalendarKeys() throws UMException {
        List returnValue = null;
        try {
            HashMap input = new HashMap();
            InvocationRequest request = this.serviceFactory.createInvocationRequest("DirectoryManagerService", "getAllBusinessCalendarKeys", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }
}

