/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.usermanager.client;

import com.adobe.idp.Context;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.um.api.AuthorizationManager;
import com.adobe.idp.um.api.UMException;
import com.adobe.idp.um.api.infomodel.Permission;
import com.adobe.idp.um.api.infomodel.PermissionInfo;
import com.adobe.idp.um.api.infomodel.PermissionSearchFilter;
import com.adobe.idp.um.api.infomodel.ReliantApplication;
import com.adobe.idp.um.api.infomodel.ResourceType;
import com.adobe.idp.um.api.infomodel.ResourceTypeACL;
import com.adobe.idp.um.api.infomodel.ResourceTypeSearchFilter;
import com.adobe.idp.um.api.infomodel.Role;
import com.adobe.idp.um.api.infomodel.RoleMembershipSearchFilter;
import com.adobe.idp.um.api.infomodel.RoleSearchFilter;
import com.adobe.livecycle.usermanager.client.ManagerServiceClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthorizationManagerServiceClient
extends ManagerServiceClient
implements AuthorizationManager {
    private ServiceClientFactory serviceFactory = null;

    public AuthorizationManagerServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceFactory = serviceClientFactory;
    }

    public boolean isUserInRole(String roleId, String principalOid) throws UMException {
        boolean returnValue = false;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("roleId", roleId);
            input.put("principalOid", principalOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "isUserInRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Boolean)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public boolean isUserInRole(String roleId) throws UMException {
        boolean returnValue = false;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("roleId", roleId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "isUserInRoleForCurrentUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Boolean)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createReliantApplication(ReliantApplication relApp) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, ReliantApplication> input = new HashMap<String, ReliantApplication>();
            input.put("relApp", relApp);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "createReliantApplication", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void createRole(Role role) throws UMException {
        try {
            HashMap<String, Role> input = new HashMap<String, Role>();
            input.put("role", role);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "createRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void createRole(Role role, List addPermissionOids) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("role", role);
            input.put("addPermissionOids", addPermissionOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "createRoleWithPerms", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteRole(String roleId) throws UMException {
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("roleId", roleId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "deleteRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void assignRole(String roleId, String[] principalOids) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("roleId", roleId);
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "assignRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void unassignRole(String roleId, String[] principalOids) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("roleId", roleId);
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "unassignRoleForPrincipals", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Role findRole(String roleId) throws UMException {
        Role returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("roleId", roleId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "findRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Role)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findRoles(RoleSearchFilter rsf) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, RoleSearchFilter> input = new HashMap<String, RoleSearchFilter>();
            input.put("rsf", rsf);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "findRoles", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Set findRolesForPrincipal(String principalOid) throws UMException {
        Set returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("principalOid", principalOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "findRolesForPrincipal", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Set)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List findRoleMembership(RoleMembershipSearchFilter rmb) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, RoleMembershipSearchFilter> input = new HashMap<String, RoleMembershipSearchFilter>();
            input.put("rmb", rmb);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "findRoleMembership", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public ReliantApplication getReliantApplication(String reliantApplicationName) throws UMException {
        ReliantApplication returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("reliantApplicationName", reliantApplicationName);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getReliantApplication", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (ReliantApplication)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List getResourceType(ResourceTypeSearchFilter rtsf) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, ResourceTypeSearchFilter> input = new HashMap<String, ResourceTypeSearchFilter>();
            input.put("rtsf", rtsf);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getResourceType", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createResourceType(ResourceType resType) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, ResourceType> input = new HashMap<String, ResourceType>();
            input.put("resType", resType);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "createResourceType", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public String createPermission(Permission perm) throws UMException {
        String returnValue = null;
        try {
            HashMap<String, Permission> input = new HashMap<String, Permission>();
            input.put("perm", perm);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "createPermission", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (String)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List getPermissions(String resourceTypeOid) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("resourceTypeOid", resourceTypeOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getPermissions", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List getPermissions(PermissionSearchFilter psf) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, PermissionSearchFilter> input = new HashMap<String, PermissionSearchFilter>();
            input.put("psf", psf);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getPermissionsWithFilter", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List getSystemPermissions(PermissionSearchFilter psf) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, PermissionSearchFilter> input = new HashMap<String, PermissionSearchFilter>();
            input.put("psf", psf);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getSystemPermissions", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void setDefaultACL(ResourceTypeACL rtDefACL) throws UMException {
        try {
            HashMap<String, ResourceTypeACL> input = new HashMap<String, ResourceTypeACL>();
            input.put("rtDefACL", rtDefACL);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "setDefaultACL", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void modifyDefaultACL(ResourceTypeACL addRtDefACL, ResourceTypeACL delRtDefACL) throws UMException {
        try {
            HashMap<String, ResourceTypeACL> input = new HashMap<String, ResourceTypeACL>();
            input.put("addRtDefACL", addRtDefACL);
            input.put("delRtDefACL", delRtDefACL);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "modifyDefaultACL", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void modifyRole(String roleName, List addPermissionOids, List removePermissionOids) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("roleName", roleName);
            input.put("addPermissionOids", addPermissionOids);
            input.put("removePermissionOids", removePermissionOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "modifyRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public List getAllRolePermissions(String roleId) throws UMException {
        List returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("roleId", roleId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getAllRolePermissions", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public boolean isMutable(String roleId) throws UMException {
        boolean returnValue = false;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("roleId", roleId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "isMutable", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Boolean)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void registerResInstance(String resType, List resIdList) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("resType", resType);
            input.put("resIdList", resIdList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "registerResInstance", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void assignPermToPrincipalForRes(String principalOid, String resourceId, List permissionOid) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("permissionOid", permissionOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "assignPermToPrincipalForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void assignPermToPrincipalsForRes(String resourceId, Map principalPermissionMap) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("resourceId", resourceId);
            input.put("principalPermissionMap", principalPermissionMap);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "assignPermToPrincipalsForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Set getPermsForPrincipalOverRes(String principalOid, String resourceId) throws UMException {
        Set returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getPermsForPrincipalOverRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Set)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map getPermsForPrincipalsOverRes(List principalOidList, String resourceId) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOidList", principalOidList);
            input.put("resourceId", resourceId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getPermsForPrincipalsOverRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void modifyPermsToPrincipalForRes(String principalOid, String resourceId, List delPerm, List addPerm) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("delPerm", delPerm);
            input.put("addPerm", addPerm);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "modifyPermsToPrincipalForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void modifyPermsToPrincipalsForRes(List principalOid, String resourceId, List delPerm, List addPerm) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("delPerm", delPerm);
            input.put("addPerm", addPerm);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "modifyPermsToPrincipalsForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deletePermsForPrincipalForRes(String principalOid, String resourceId, List permList) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("permList", permList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "deletePermsForPrincipalForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deletePermsForPrincipalsForRes(List principalOid, String resourceId, List permList) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("permList", permList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "deletePermsForPrincipalsForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Map findRolesForPrincipals(List principalOid) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, List> input = new HashMap<String, List>();
            input.put("principalOid", principalOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "findRolesForPrincipals", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void assignRoles(String[] roleId, String[] principalOids) throws UMException {
        try {
            HashMap<String, String[]> input = new HashMap<String, String[]>();
            input.put("roleId", roleId);
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "assignRoles", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void unassignRoles(String[] roleId, String[] principalOids) throws UMException {
        try {
            HashMap<String, String[]> input = new HashMap<String, String[]>();
            input.put("roleId", roleId);
            input.put("principalOids", principalOids);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "unassignRoles", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Map areUsersInRole(String roleId, List principalOid) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("roleId", roleId);
            input.put("principalOid", principalOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "areUsersInRole", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public PermissionInfo hasPermission(String principalOid, String resourceId, String permissionOid) throws UMException {
        PermissionInfo returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("permissionOid", permissionOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "hasPermission", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (PermissionInfo)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public PermissionInfo hasPermission(String principalOid, String resourceId, Permission perm) throws UMException {
        PermissionInfo returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("perm", perm);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "hasPermissionObj", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (PermissionInfo)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map hasPermission(List principalOid, String resourceId, String permissionOid) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("permissionOid", permissionOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "havePermissions", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map hasPermission(List principalOid, String resourceId, Permission perm) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("perm", perm);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "havePermissionsObj", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Set getResourcesForPrincipal(String principalOid, String permissionOid) throws UMException {
        Set returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("principalOid", principalOid);
            input.put("permissionOid", permissionOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getResourcesForPrincipal", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Set)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Map getResourcesForPrincipals(List principalOid, String permissionOid) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("permissionOid", permissionOid);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "getResourcesForPrincipals", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public void modifyPermsToPrincipalForRes(String principalOid, String resourceId, List desiredPerms) throws UMException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("principalOid", principalOid);
            input.put("resourceId", resourceId);
            input.put("desiredPerms", desiredPerms);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "modifyDesiredPermsToPrincipalForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Map findPriPermInfoForRes(String resourceId) throws UMException {
        Map returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("resourceId", resourceId);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "findPriPermInfoForRes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Map)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Context testContext(Context ctx) throws UMException {
        Context returnValue = null;
        try {
            HashMap<String, Context> input = new HashMap<String, Context>();
            input.put("ctx", ctx);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthorizationManagerService", "testContext", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Context)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }
}

