/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.usermanager.client;

import com.adobe.idp.Context;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.um.api.AuthenticationManager;
import com.adobe.idp.um.api.UMException;
import com.adobe.idp.um.api.infomodel.AuthResult;
import com.adobe.idp.um.api.infomodel.HttpRequestToken;
import com.adobe.idp.um.api.infomodel.SSOToken;
import com.adobe.livecycle.usermanager.client.ManagerServiceClient;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class AuthenticationManagerServiceClient
extends ManagerServiceClient
implements AuthenticationManager {
    private ServiceClientFactory serviceFactory = null;

    public AuthenticationManagerServiceClient(ServiceClientFactory serviceClientFactory) {
        this.serviceFactory = serviceClientFactory;
    }

    public AuthResult authenticate(String username, byte[] password, List domainList) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("username", username);
            input.put("password", password);
            input.put("domainList", domainList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String username, byte[] password) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("username", username);
            input.put("password", password);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticate", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(byte[] ssoToken, boolean createAssertion) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("ssoToken", ssoToken);
            input.put("createAssertion", new Boolean(createAssertion));
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithSSOToken", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String wssecHeader, List domainList) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("wssecHeader", wssecHeader);
            input.put("domainList", domainList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithWSHeaderAndDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String wssecHeader) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("wssecHeader", wssecHeader);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithWSHeader", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult getAuthResultOnBehalfOfUser(String canonicalName, String domainName, Context caller) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("canonicalName", canonicalName);
            input.put("domainName", domainName);
            input.put("caller", caller);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "getAuthResultOnBehalfOfUser", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public SSOToken getSSOToken(Context context) throws UMException {
        SSOToken returnValue = null;
        try {
            HashMap<String, Context> input = new HashMap<String, Context>();
            input.put("context", context);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "getSSOToken", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (SSOToken)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public byte[] getSSOTokenBytes(Context context) throws UMException {
        byte[] returnValue = null;
        try {
            HashMap<String, Context> input = new HashMap<String, Context>();
            input.put("context", context);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "getSSOTokenBytes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (byte[])response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(Element wssecHeaderElement, List domainList) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("wssecHeaderElement", wssecHeaderElement);
            input.put("domainList", domainList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithWSHeaderElementAndDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(Element wssecHeaderElement) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Element> input = new HashMap<String, Element>();
            input.put("wssecHeaderElement", wssecHeaderElement);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithWSHeaderElement", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String unsignedData, String signatureValue, List domainList) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("unsignedData", unsignedData);
            input.put("signatureValue", signatureValue);
            input.put("domainList", domainList);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateCertWithDomain", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(String unsignedData, String signatureValue) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("unsignedData", unsignedData);
            input.put("signatureValue", signatureValue);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateCert", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public List getAuthSchemes() throws UMException {
        List returnValue = null;
        try {
            HashMap input = new HashMap();
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "getAuthSchemes", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (List)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult validateAssertion(String assertion) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("assertion", assertion);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "validateAssertion", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public Context validateAssertion(Context ctx) throws UMException {
        Context returnValue = null;
        try {
            HashMap<String, Context> input = new HashMap<String, Context>();
            input.put("ctx", ctx);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "validateAssertionVariant", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (Context)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult authenticate(HttpRequestToken requestToken) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, HttpRequestToken> input = new HashMap<String, HttpRequestToken>();
            input.put("requestToken", requestToken);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "authenticateWithHttpToken", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }

    public AuthResult renewAssertion(String assertionId, Context context) throws UMException {
        AuthResult returnValue = null;
        try {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("assertionId", assertionId);
            input.put("context", context);
            InvocationRequest request = this.serviceFactory.createInvocationRequest("AuthenticationManagerService", "renewAssertion", input, true);
            InvocationResponse response = this.serviceFactory.getServiceClient().invoke(request);
            returnValue = (AuthResult)response.getOutputParameter("result");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return returnValue;
    }
}

